# License: 
# 
# Copyright 2004 Mayo Foundation for Medical Education and Research. 
# 
# This program is free software; you can redistribute it and/or modify it under the terms of 
# the GNU General Public License as published by the Free Software Foundation; either 
# version 2 of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but WITHOUT ANY 
# WARRANTY; without even the implied warranty of MERCHANTABILITY or 
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
# more details.
# 
waldtest <- function(fit, cmat, var=fit$var) {
    if (is.vector(fit)) beta <- fit
    else                beta <- coef(fit)
    nvar    <- length(beta)
    missing <- is.na(beta)

    if (ncol(var) != nrow(var) || ncol(var) != nvar)
	    stop("Mismatched coefficient and variance matrices")

    if (any(missing)) {
	beta <- beta[!missing]
	var  <- var[!missing, !missing]
	}

    if (!is.matrix(cmat)) {
	if (length(cmat)== nvar) cmat <- as.matrix(cmat)
	else {  #vector of numbers
	    whichvar <- floor(cmat) #make sure they are integers
	    if (any(whichvar <1 | whichvar > nvar))
		    stop("Coefficient number out of range")
	    cmat <- 0*diag(nvar)
	    cmat[cbind(whichvar, whichvar)] <- 1
	    }
	}

    if (nrow(cmat) != nvar) stop ("Wrong number of rows in cmat")
    if (any(missing)) cmat <- cmat[!missing,]
    test <- coxph.wtest(t(cmat) %*% var %*% cmat, cmat%*%beta)
    pval <- 1- pchisq(test$test, df=test$df)
    c(chisq=test$test, df=test$df, p = signif(pval,2))
    }
