#$Author: sinnwell $
#$Date: 2009/12/28 15:25:59 $
#$Header: /people/biostat3/sinnwell/Projects/LDpairs/Make/RCS/print.ld.pairs.q,v 1.3 2009/12/28 15:25:59 sinnwell Exp $
#$Locker:  $
#$Log: print.ld.pairs.q,v $
#Revision 1.3  2009/12/28 15:25:59  sinnwell
#assembled data.frame from scratch to work for R and S+
#
#Revision 1.2  2007/04/21 20:27:56  sinnwell
#fix error that couldn't print if r2 was null, change to NA
#
#Revision 1.1  2003/10/14 19:51:28  sinnwell
#Initial revision
#

# Sinnwell JP, Schaid DJ
# Mayo Clinic Rochester, 2003

print.ld.pairs <- function(x, digits=max(options()$digits-2, 5), ...)
  ## Print ld.pairs object as a data frame
{
  if(is.null(x$r2)) {
    x <- data.frame(loc1=x$loc1, loc2=x$loc2,
                    loc1.label=x$loc1.label, loc2.label=x$loc2.label,
                    dprime.ave=x$dprime.ave, r2=rep(NA, length(x$loc1)),
                    lr.stat=x$lr.stat, lr.df=x$lr.df, lr.pval=x$lr.pval,
                    comp.stat=x$comp.stat, comp.df=x$comp.df, comp.pval=x$comp.pval)
  } else {
    
     x <- data.frame(loc1=x$loc1, loc2=x$loc2,
                    loc1.label=x$loc1.label, loc2.label=x$loc2.label,
                    dprime.ave=x$dprime.ave, r2=x$r2,
                    lr.stat=x$lr.stat, lr.df=x$lr.df, lr.pval=x$lr.pval,
                    comp.stat=x$comp.stat, comp.df=x$comp.df, comp.pval=x$comp.pval)
   } 
  
  print(x, digits=digits, ...)
  invisible()

}
