\name{plot.ld.pairs}
\alias{plot.ld.pairs}
\title{
  Plot results demonstrating Linkage Disequilibrium from ld.pairs 
}
\description{
Make a set of boxes, one box for every pair of loci.  Fill each box
with line densities reflecting the dprime.ave measure of LD.
}
\usage{
plot.ld.pairs <- function(x, ld.measure="dprime.ave", line.density=6, fill.type="both",
        locus.label=as.character(1:max(c(x$loc1,x$loc2))), adj=.5, srt=0, ...)
}
\arguments{
\item{x}{
An object created by ld.pairs
}
\item{ld.measure}{
Character string indicatin which ld measure to plot.  Choose from
"dprime.ave", "r2", "comp.pval".  Five categories are chosen for the
measures.  Dprime.ave and r2 categories are evenly spaced between 0
and 1, whereas comp.pval is based on the -log10 of the compositeLD p-value.
}
\item{line.density}{
May altar the line density to show more or less contrast between
levels of dprime.ave.  If you change plotting size, you will want to
change this with it.
}
\item{fill.type}{
Character string, indicate to plot the lines diagonally going up,
down, or both.
}
\item{locus.label}{
Locus names to plot at the tick marks.  Length is same as number of loci.
}
\item{adj}{
 
String justification for locus.label on both the x- and y-axes. 
0 means left justify, 1 means right justify, .5 means to center the
text. Other numbers are a corresponding distance between the extremes.  
}
\item{srt}{
Character rotation for 'locus.label' in degrees measured counterclockwise from   
horizontal.  Only used for the x-axis locus labels.
}
\item{\dots }{
Extra plot parameters.
}
}
\value{
Nothing returned
}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{
ld.pairs
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 43267.
