#$Author: sinnwell $
#$Date: 2011/02/25 14:13:57 $
#$Header: /projects/genetics/cvs/cvsroot/hwe/R/hwe.sim.q,v 1.3 2011/02/25 14:13:57 sinnwell Exp $
#$Locker:  $
#$Log: hwe.sim.q,v $
#Revision 1.3  2011/02/25 14:13:57  sinnwell
#C long to int, now works in R on linux
#
#Revision 1.2  2006/10/17 18:14:10  sinnwell
#add keywords
#
hwe.sim <- function(a1,a2,n.sim=1000,iseed=NULL){

# Title: HWE test by simulations (approximates exact test for multiple alleles)

# Simulated  pval for approximating the exact test for HWE with
# multiple alleles (see Weir, Genetic Data Analysis II, page 108)
# input a1 and a2 are vectors of alleles with length = n, n = number
# of subjects
#
# The parameter iseed allows the user to specify a seed to be used to
# generate random numbers (useful for reproducing results).  If no seed is 
# specified, random variables are generated with the current value of 
# .Random.seed.


# a1 and a2 are vectors of alleles w/o missing values
obs <- hwe.stats(a1,a2)

ret.list <- numeric(3)
ret.code <- numeric(1)

if(!is.null(iseed))
  { set.seed(iseed) }

seed.array <- runif(3)

# The seeds for the ranAS183 random number generator used in the C function
# hwe_sim must be between 1 and 30000, but bigger is better (we think), so we
# add 10000

iseed1 = 10000 + 20000*seed.array[1]
iseed2 = 10000 + 20000*seed.array[2]
iseed3 = 10000 + 20000*seed.array[3]

out <- .C("hwe_sim",
          alleles=as.integer(c(a1,a2)),
          n.sim=as.integer(n.sim),
          obs.n=as.integer(obs$n),
          obs.nallele=as.integer(obs$n.allele),
          obs.ex=as.double(obs$ex),
          obs.u=as.double(obs$u.score),
          iseed1=as.integer(iseed1),
          iseed2=as.integer(iseed2),
          iseed3=as.integer(iseed3),
          rc=as.integer(ret.code),
          ret.list=as.double(ret.list),
          PACKAGE="hwe")

if(out$rc != 0)
  {
    if(out$rc == -1)
      warning("Number of simulations <= zero")
    if(out$rc == -2)
      warning("Length of allele <= zero: hwe.sim failed")
    if(out$rc == -3)
      warning("Number of allele codes <= zero: hwe.sim failed")
    if(out$rc == -4)
      warning("Memory allocation failed: hwe.sim failed")
  }
    
pval.chi <- out$ret.list[1]
pval.like <- out$ret.list[2]
pval.rare <- out$ret.list[3]

return(list(pval.like=pval.like,pval.chi=pval.chi,pval.rare=pval.rare))

}






