/*  SCCS     @(#)sim.c	1.1    06/18/97     */
#include <stdio.h>
/***  Function simprob:
****
****     Compute probality of selecting a given parent allele type
****     based on the given vector of betas.
****
****
***/

double simprob(long m,long f,long k,double *betasim) {

  double prob;
  long temp;

  prob=0;

  if ( (m+f) > 0 ) {
   
    /***Add Main Effects***/
    if (m > 0) prob+=betasim[m-1];
    if (f > 0) prob+=betasim[f-1];

    /***Add interaction Effects***/
    if (m!=f) {
      if (m > f) {
        temp=m;
        m=f;
        f=temp;
      }
    
      m++;
      f++;
      
      prob+=betasim[ ((k-1) + (m-1)*k - ((m-1)*m)/2 + (f-m) -1) ];
      

    }

  }
  return prob;

}



/***  Function simsetup:
****
****    given a vector of betas and the 4 possible parent allele vectors,
****    sets up a matrix of p's to be used to generate random numbers,
****    and computes meantot=sum of the x*p* over the 4 possible types for
****    all cases, computes v inverse).
***/
#include <math.h>
struct geno {
   long c1;
   long c1code;
   long c2;
   long c2code;
   long m1;
   long m1code;
   long m2;
   long m2code;
   long f1;
   long f1code;
   long f2;
   long f2code;
};
void simsetup(double *betasim, long n_alleles,struct geno *indata,
              long **x1,long **x2,long **x3,long **x4,  
              long n_cases, double **psim,double **v_tdt , double *mtot_tdt,
              double **v_dom,double *mtot_dom,double **v_rec,double *mtot_rec)
{

double simprob(long m,long f,long k,double *betasim);
double *dvector(long n);

long i,j,k;
double e1,e2,e3,e4,denom,*umean_tdt,*umean_dom,*umean_rec;


  umean_tdt=dvector(n_alleles);
  umean_dom=dvector(n_alleles);
  umean_rec=dvector(n_alleles);

  for (i=1; i<n_alleles; i++) {
    for (j=1; j<n_alleles; j++) {
      v_tdt[i][j]=0;
      v_dom[i][j]=0;
      v_rec[i][j]=0;
    }
    umean_tdt[i]=0;
    mtot_tdt[i]=0;
    umean_dom[i]=0;
    mtot_dom[i]=0;
    umean_rec[i]=0;
    mtot_rec[i]=0;
  }

  for (i=0; i<n_cases; i++) {

       /***CALCULATE (x*')B***/
       e1=e2=e3=e4=0;
       e1=simprob(indata[i].m1code,indata[i].f1code,n_alleles+1,betasim);
       e2=simprob(indata[i].m1code,indata[i].f2code,n_alleles+1,betasim);
       e3=simprob(indata[i].m2code,indata[i].f1code,n_alleles+1,betasim);
       e4=simprob(indata[i].m2code,indata[i].f2code,n_alleles+1,betasim);      

       /***CALCULATE exp((x*')B)****/
       e1=exp(e1);
       e2=exp(e2);
       e3=exp(e3);
       e4=exp(e4);

       denom=e1 + e2 + e3 + e4;

       psim[i][0]=e1/denom;
       psim[i][1]=(e1+e2)/denom;
       psim[i][2]=(e1+e2+e3)/denom;
       psim[i][3]=1.0;

       /***CALCULATE sum of meanu***/
       for (j=0; j<n_alleles; j++) {

         umean_tdt[j]=((x1[i][j]+x2[i][j]+x3[i][j]+x4[i][j])/4.0);
         mtot_tdt[j]+=umean_tdt[j];

         umean_dom[j]=( ((x1[i][j]>0) +
                         (x2[i][j]>0) +
                         (x3[i][j]>0) +
                         (x4[i][j]>0))/4.0);
         mtot_dom[j]+=umean_dom[j];

         umean_rec[j]=( ((x1[i][j]==2) +
                         (x2[i][j]==2) +
                         (x3[i][j]==2) +
                         (x4[i][j]==2))/4.0);
         mtot_rec[j]+=umean_rec[j];
       }
        
       /***CALCULATE V MATRIX***/
       for (j=0; j<n_alleles; j++) { 
          for (k=0; k<n_alleles; k++) {
             v_tdt[j][k]+= ( ( (x1[i][j]*x1[i][k]) +
                               (x2[i][j]*x2[i][k]) +
                               (x3[i][j]*x3[i][k]) +
                               (x4[i][j]*x4[i][k]) )/4.0 - 
                             (umean_tdt[j]*umean_tdt[k]));

             v_dom[j][k]+= ( ( (x1[i][j]>0)*(x1[i][k]>0) +
                               (x2[i][j]>0)*(x2[i][k]>0) +
                               (x3[i][j]>0)*(x3[i][k]>0) +
                               (x4[i][j]>0)*(x4[i][k]>0) )/4.0 -
                             (umean_dom[j]*umean_dom[k]));
         
             v_rec[j][k]+= ( ( (x1[i][j]==2)*(x1[i][k]==2) +
                               (x2[i][j]==2)*(x2[i][k]==2) +
                               (x3[i][j]==2)*(x3[i][k]==2) +
                               (x4[i][j]==2)*(x4[i][k]==2) )/4.0 -
                        (umean_rec[j]*umean_rec[k]));
             	
          }
       }
   }
  
  /***INVERT V***/
  cholesky2(v_tdt,n_alleles);
  chinv2(v_tdt,n_alleles);
  cholesky2(v_dom,n_alleles);
  chinv2(v_dom,n_alleles);
  cholesky2(v_rec,n_alleles);
  chinv2(v_rec,n_alleles);

  return;
}


/*************************************************************************
******   Function simulate:
******     randomly picks one of the 4 possible sets of parent alleles to
******     use as the child case based on probabilities specified in the
******     psim matrix.  Computes the sum of the alleles for each type of
******     allele over all cases.
******
******     Returns:  simulated score statistic
*************************************************************************/

double simulate(double **psim,long n_alleles,long n_cases,
                long **x1,long **x2,long **x3,long **x4,
                double *mtot_tdt,double **v_tdt,double *simscore_tdt,
                double *mtot_dom,double **v_dom,double *simscore_dom,
                double *mtot_rec,double **v_rec,double *simscore_rec) {

double *dvector(long n);
double ranAS183();

int index;
long i,j;
double *xtot_tdt,*xtot_dom,*xtot_rec,*u_tdt,*u_dom,*u_rec;
double urv;

    u_tdt=dvector(n_alleles);
    u_dom=dvector(n_alleles);
    u_rec=dvector(n_alleles);

    xtot_tdt=dvector(n_alleles);
    xtot_dom=dvector(n_alleles);
    xtot_rec=dvector(n_alleles);

    for (j=0; j<n_alleles; j++) {
      xtot_tdt[j]=0;xtot_dom[j]=0;xtot_rec[j]=0;
      u_tdt[j]=0;u_dom[j]=0;u_rec[j]=0;
    }

    for (i=0; i<n_cases; i++) {

      urv=ranAS183();
      index=0;

      if (urv <= psim[i][0]) index=1;
      else {
        if (urv <= psim[i][1]) index=2;
        else {
          if (urv <= psim[i][2]) index=3;
          else index=4;
        }
      } 

      switch(index) {
        case 1:
          for (j=0; j<n_alleles; j++) { 
            xtot_tdt[j]+=x1[i][j];
            xtot_dom[j]+=(x1[i][j]>0);
            xtot_rec[j]+=(x1[i][j]==2);
          }
          break;
        case 2:
          for (j=0; j<n_alleles; j++) { 
            xtot_tdt[j]+=x2[i][j];
            xtot_dom[j]+=(x2[i][j]>0);
            xtot_rec[j]+=(x2[i][j]==2);
          }
          break;
        case 3:
          for (j=0; j<n_alleles; j++) { 
            xtot_tdt[j]+=x3[i][j];
            xtot_dom[j]+=(x3[i][j]>0);
            xtot_rec[j]+=(x3[i][j]==2);
          }
          break;
        case 4:
          for (j=0; j<n_alleles; j++) { 
            xtot_tdt[j]+=x4[i][j];
            xtot_dom[j]+=(x4[i][j]>0);
            xtot_rec[j]+=(x4[i][j]==2);
          }
          break;
        default:
          printf("RANDOM NUMBER GENERATION PRODUCED UNEXPECTED RESULTS");
          return;
      }
    }

    for (j=0; j<n_alleles; j++) {
      u_tdt[j]=xtot_tdt[j]-mtot_tdt[j];
      u_dom[j]=xtot_dom[j]-mtot_dom[j];
      u_rec[j]=xtot_rec[j]-mtot_rec[j];
    }

    *simscore_tdt=*simscore_dom=*simscore_rec=0;
    for (i=0; i< n_alleles; i++) {
      for (j=0; j< n_alleles; j++) {
        if (j<=i) {
          *simscore_tdt+=u_tdt[i]*u_tdt[j]*v_tdt[j][i];
          *simscore_dom+=u_dom[i]*u_dom[j]*v_dom[j][i];
          *simscore_rec+=u_rec[i]*u_rec[j]*v_rec[j][i];
        } 
        else {
          *simscore_tdt+=u_tdt[i]*u_tdt[j]*v_tdt[i][j];
          *simscore_dom+=u_dom[i]*u_dom[j]*v_dom[i][j];
          *simscore_rec+=u_rec[i]*u_rec[j]*v_rec[i][j];
        }
      }
    }   
}

   



















