/*  SCCS     @(#)score.c	1.1    06/18/97     */
/***Function score.c
****
****   Purpose: Calculate Score Statistics for GTDT, GDOM, GREC
****
****   Returns: Nothing
****
****   score_tdt,score_dom and score_rec contain score statistics upon return.
****   pscore_tdt,pscore_dom,pscore_rec contain p-values upon return.
****   rank_tdt,rank_dom,rank_rec contain degrees of freedom upon return.
****/

void  score(double *score_tdt,double *score_dom,double *score_rec,
            double *pscore_tdt,double *pscore_dom,double *pscore_rec,
            int *rank_tdt,int *rank_dom,int *rank_rec,
            long n_cases,long n_alleles,long **x,long **x1,long **x2,
            long **x3,long **x4) {


  double gammad(double x,double p,int *ifault);
  double *dvector(long n);
  double **dmatrix(long nr, long nc);

  double **v_tdt,**v_dom,**v_rec,*umean_tdt,*umean_dom,*umean_rec,
         *u_tdt,*u_dom,*u_rec;
  long i,j,k;
  int ifault,tdt_comp,dom_comp,rec_comp;

  umean_tdt=dvector(n_alleles);
  umean_dom=dvector(n_alleles);
  umean_rec=dvector(n_alleles);

  u_tdt=dvector(n_alleles);
  u_dom=dvector(n_alleles);
  u_rec=dvector(n_alleles);

  v_tdt=dmatrix(n_alleles,n_alleles);
  v_dom=dmatrix(n_alleles,n_alleles);
  v_rec=dmatrix(n_alleles,n_alleles);


  for (i=0; i<n_alleles; i++) {
    for (j=0; j<n_alleles; j++) {
      v_tdt[i][j]=v_dom[i][j]=v_rec[i][j]=0;
    }
  }

  for (j=0; j<n_alleles; j++) {
    u_tdt[j]=u_dom[j]=u_rec[j]=0;
  }

  for (i=0; i<n_cases; i++) {

    /***Calculate U***/
    for (j=0; j<n_alleles; j++) {

      umean_tdt[j]=(x1[i][j]+x2[i][j]+x3[i][j]+x4[i][j])/4.0;
      u_tdt[j]+=(x[i][j]-umean_tdt[j]);

      umean_dom[j]=( (x1[i][j]>0) +
                     (x2[i][j]>0) +
                     (x3[i][j]>0) +
                     (x4[i][j]>0) )/4.0;
      u_dom[j]+=( (x[i][j]>0) - umean_dom[j] );

      umean_rec[j]=( (x1[i][j]==2) +
                     (x2[i][j]==2) +
                     (x3[i][j]==2) +
                     (x4[i][j]==2) )/4.0;
      u_rec[j]+=( (x[i][j]==2) - umean_rec[j] );

    }

    
    /***Calculate V***/
    for (j=0; j<n_alleles; j++) {
      for (k=0; k<n_alleles; k++) {    

        v_tdt[j][k]+= ( ( (x1[i][j]*x1[i][k]) +
                          (x2[i][j]*x2[i][k]) +
                          (x3[i][j]*x3[i][k]) +
                          (x4[i][j]*x4[i][k]) )/4.0 - 
                        (umean_tdt[j]*umean_tdt[k]));

        v_dom[j][k]+= ( ( (x1[i][j]>0)*(x1[i][k]>0) +
                          (x2[i][j]>0)*(x2[i][k]>0) +
                          (x3[i][j]>0)*(x3[i][k]>0) +
                          (x4[i][j]>0)*(x4[i][k]>0) )/4.0 -
                        (umean_dom[j]*umean_dom[k]));
         
        v_rec[j][k]+= ( ( (x1[i][j]==2)*(x1[i][k]==2) +
                          (x2[i][j]==2)*(x2[i][k]==2) +
                          (x3[i][j]==2)*(x3[i][k]==2) +
                          (x4[i][j]==2)*(x4[i][k]==2) )/4.0 -
                        (umean_rec[j]*umean_rec[k]));

      }
    }

  }

  tdt_comp=dom_comp=rec_comp=0;
  for (i=0; i<n_alleles; i++) {
    if (v_tdt[i][i] > 0.0)
      tdt_comp=1;
    if (v_dom[i][i] > 0.0)
      dom_comp=1;
    if (v_rec[i][i] > 0.0)
      rec_comp=1;
  }

  if (tdt_comp==1) {    
    *rank_tdt=cholesky2(v_tdt,n_alleles);
    chinv2(v_tdt,n_alleles);
  }
  if (*rank_tdt==0) 
    tdt_comp=0;

  if (dom_comp==1) {
    *rank_dom=cholesky2(v_dom,n_alleles);
    chinv2(v_dom,n_alleles);
  }
  if (*rank_dom==0)
    dom_comp=0;

  if (rec_comp==1) {
    *rank_rec=cholesky2(v_rec,n_alleles);
    chinv2(v_rec,n_alleles);
  }
  if (*rank_rec==0)
    rec_comp=0;
  
  *score_tdt=*score_dom=*score_rec=0;
  for (i=0; i< n_alleles; i++) {
    for (j=0; j< n_alleles; j++) {
      if (j<=i) { 
        *score_tdt+=u_tdt[i]*u_tdt[j]*v_tdt[j][i];
        *score_dom+=u_dom[i]*u_dom[j]*v_dom[j][i];
        *score_rec+=u_rec[i]*u_rec[j]*v_rec[j][i];
      }
      else {
        *score_tdt+=u_tdt[i]*u_tdt[j]*v_tdt[i][j];
        *score_dom+=u_dom[i]*u_dom[j]*v_dom[i][j];
        *score_rec+=u_rec[i]*u_rec[j]*v_rec[i][j];
      }
    }
  }    

  if (tdt_comp==1)
    *pscore_tdt=1-gammad(*score_tdt/2.0,*rank_tdt/2.0,&ifault);
  else
    *rank_tdt=0;
  if (dom_comp==1)
    *pscore_dom=1-gammad(*score_dom/2.0,*rank_dom/2.0,&ifault);
  else
    *rank_dom=0;
  if (rec_comp==1)
    *pscore_rec=1-gammad(*score_rec/2.0,*rank_rec/2.0,&ifault);
  else
    *rank_rec=0;      
}













