/*  SCCS     @(#)readpar.c	1.4    05/10/01     */
/*************************************************************************
*  Function     readpar()  
*
*  Purpose:     Read parameter file
*
*  Arguments:   
*                            
*  Returns:     Nothing
*             
*************************************************************************/
#include <stdio.h>
#include <string.h>
#include "dlistheader.h"

/* New functions  below needed for GASSOC version 1.06 */
int add_word(const void *key_word,DList *word_list, DListElmt *element);

char* remove_spaces(char *instring);
/* New functions above needed for GASSOC version 1.06 */


/* Added the parameter word_list it's needed for GASSOC version 1.06 */
void readpar(FILE *par,int *dloc,int *nliab,int *mstart,int *mstop, 
             DList *word_list) {

int nloci,i,typloc,j,counter=0;
char line[200];
char *word;


  fscanf(par,"%i",&nloci);

  for (i=0; i<3; i++) {
    fgets(line,200,par);
  }
   

  for (i=1;i<=nloci;i++) {
    fscanf(par,"%i",&typloc);
    if (! ( (typloc==3) || (typloc==1) ) ) {
      printf("Error in par file: locus not of type 1 or 3\n");
      exit(1);
    }
    if (typloc==1) {
      *dloc=i;
      fgets(line,200,par);

      fgets(line,200,par);
      fscanf(par,"%i",nliab);
      for (j=0;j<=*nliab;j++){
        fgets(line,200,par);
      }
    }
    else {
      fgets(line,200,par);

     /* New code below needed for GASSOC version 1.06 */

      word = strtok(line,"#");
      while (word != NULL){ /* This While loop parses a line that contains   */
        counter++;          /* numbered allele factors and number of alleles */
        if (counter==2){
           word=remove_spaces(word);
           add_word(word,word_list,dlist_tail(word_list));
	 }
        word = strtok(NULL,"#");
      }
      if (counter == 1)
          add_word("NOTFOUND",word_list,dlist_tail(word_list));

      counter = 0;
      fgets(line,200,par);

      while (word != NULL){ /* This While loop parses a line that contains */
        counter++;          /* gene frequencies.                           */
        if (counter==2){
           word=remove_spaces(word);
           add_word(word,word_list,dlist_tail(word_list));
        }      
        word = strtok(NULL,"#");
      }
      if (counter == 1)
          add_word("NOTFOUND",word_list,dlist_tail(word_list));
   
    } /* New code above needed for GASSOC version 1.06 */
  }
  if (*dloc > 1) 
    *mstart=1;
  else
    *mstart=2;
   
  if (*dloc==nloci)
    *mstop=nloci-1;
  else
    *mstop=nloci;

}





