/*  SCCS     @(#)max_like.c	1.1    06/18/97     */
/*** Function max_like:
****
****   purpose:  compute maximum likelihood of beta vector
****
****   returns:  1 if convergence
****             0 if no convergence
****
*****************************************************************************/

#include <math.h>
#define EPSILON .000001

int max_like(long n_cases,long n_alleles,long maxiter,int iter,double *beta,
             long **x,long **x1,long **x2,long **x3,long **x4,
             double **v,double *lnl) {

  double *dvector(long n);
  void calc_uv(long n_cases, long n_alleles,double *beta,double *u,
               double **v,long **x1,long **x2,long **x3,long **x4,long **x);
  void print_iter_hist(double *beta,double *u,double **v,double lnl,
                       long n_cases,long n_alleles,long niter);
  double log_likely(double *beta,long **x,long **x1,
                    long **x2,long **x3,long **x4,
                    long n_cases,long n_alleles);

  long iterate,niter,i;
  double *u,*betanew,lnlnew;

  niter=0;
  iterate=1;

  u=dvector(n_alleles);
  betanew=dvector(n_alleles);

  /***ITERATE***/ 
  while (iterate==1) {

    calc_uv(n_cases,n_alleles,beta,u,v,x1,x2,x3,x4,x);
     
    if (iter==1) {
      print_iter_hist(beta,u,v,*lnl,n_cases,n_alleles,niter);
    }

    /***USE CHOLESKY DECOMPOSITION ON V***/
    cholesky2(v,n_alleles);

    /***SOLVE Vd=U for d***/
    chsolve2(v,n_alleles,u);

    /***CALCULATE Bnew**/            
    for (i=0; i<n_alleles; i++) {
      betanew[i]=beta[i]+u[i];
    }

    lnlnew=log_likely(betanew,x,x1,x2,x3,x4,n_cases,n_alleles);

    /***CHECK FOR CONVERGENCE***/
    if ( fabs(lnlnew-*lnl) < EPSILON ) {
      calc_uv(n_cases,n_alleles,betanew,u,v,x1,x2,x3,x4,x);
      return 1;
    }

    /***HAS NOT CONVERGED YET***/
    else {
      /***INCREMENT ITERATION COUNTER***/
      niter++;

      /***STOP ON MAXIMUM ITERATION****/
      if (niter > maxiter)
        iterate=0;

      /***UPDATE ln L and Betas for next iteration***/
      *lnl=lnlnew;
      for (i=0; i<n_alleles; i++) 
        beta[i]=betanew[i];
    }
   
  }
 
  return 0;
}















