/*  SCCS     @(#)log_likely.c	1.1    06/18/97     */
/***Calculate Log Likelihood given Betas and X
****
****   Returns: log likelihood
***/
#include <math.h>
double log_likely(double *beta,long **x,long **x1,
                  long **x2,long **x3,long **x4,
                  long n_cases,long n_alleles) 
{
long i,j;
double lnl,term1,term2,term3,term4,term5;

    /***CALULATE ln L***/
    lnl=0;
    for (i=0; i<n_cases; i++) {
      term1=term2=term3=term4=term5=0;
      for (j=0; j<n_alleles; j++) {
         term1+= x[i][j]*beta[j];
         term2+=x1[i][j]*beta[j];
         term3+=x2[i][j]*beta[j];
         term4+=x3[i][j]*beta[j];
         term5+=x4[i][j]*beta[j];
      }
      lnl+=(term1 - log(exp(term2)+exp(term3)+exp(term4)+exp(term5)));
    }
    return lnl;
}

