/*  SCCS     @(#)int_input.c	1.5    05/10/01     */
/*************************************************************************
*  Function     int_input()  
*
*  Purpose:     retrieve input parameters interactively from screen
*
*  Arguments:   
*                            
*  Returns:     pointer to vector of betas to be used in simulation
*             
*************************************************************************/
#include<stdio.h>
#include<string.h>
#include "dlistheader.h"

/* New code below for GASSOC version 1.06 */
/*-------------------------------------------------------------------------*/
/*  Pre- word cannot be NULL.                                              */
/* Post- word is added to the linked list word_list in the key_word field. */

int add_word(const void *key_word,DList *word_list, 
                         DListElmt *element);

/* New code above for GASSOC version 1.06 */


/* Additional parameters grrmarker,grrallele,word_list */
/* needed for GASSOC version 1.06                      */

double *int_input(FILE **in,int *dloc,int *nliab,int *mstart,int *mstop,
                 int *iter,long *maxiter,long *sim,int *seeda,int *seedb,
                 int *seedc, int *simout,char *outfilename,int *bsim,
                 int *ofile,char *outresults, char *grrmarker, long *grrallele,
                 DList *word_list) {

  DListElmt *element;
  double *dvector(long n);

  char infilename[25]="in.dat";
  char response;
  int  nall,vlen,i,ok,rc,nmarks,marker;
  double *betasim = NULL,num;
  

  ok=1;
  while (ok) {
    fflush(stdin);
    printf("\nName of the input file>  ");
    scanf("%25s",infilename);
    printf("\n");
    *in=fopen(infilename,"r");
    if (*in == NULL) {
      printf("Input file not found\n");
    }
    else
      ok=0;
  }

  ok=1;
  while (ok) {
    printf("\nAny liability classes? (Y/N)> ");
    fflush(stdin);
    rc=scanf("%c",&response);
    printf("\n");
    response=toupper(response);
    if ( (response=='Y') || (response=='N') ) {
      ok=0;
      if (response=='Y')
        *nliab=2;
      else
        *nliab=1;
    }
    else {
      printf("Invalid entry\n");
    }
  }

  printf("\nRelative column position of loci:");

  ok=1;
  while (ok) {
    printf("\n\tDisease locus>  ");
    fflush(stdin);
    rc=scanf("%i", dloc);
    if ((*dloc <= 0) || (rc==0)) {
      printf("\nInvalid entry for disease locus\n");
    }
    else
      ok=0; 
  }


  ok=1;
  while (ok) {
    printf("\n\tFirst marker locus>  ");
    fflush(stdin);
    rc=scanf("%i",mstart);
    if ((*mstart <= 0) || (rc==0)) {
      printf("\nInvalid entry for marker locus\n");
    }
    else {
      if (*mstart==*dloc) {
        printf("\nInvalid entry: marker locus=disease locus\n");
      }
      else
        ok=0;
    } 
  }

  ok=1;
  while (ok) {
    printf("\n\tLast marker locus>  ");
    fflush(stdin);
    rc=scanf("%i",mstop);
    if ((*mstop < *mstart) || (rc==0)) { 
      printf("\nInvalid entry for marker locus\n");
    }
    else {
      if (*mstop==*dloc) {
        printf("\nInvalid entry: marker locus=disease locus\n");
      }
      else {
        ok=0;
        if (*mstart==*mstop)
          printf("\nAnalyze marker %d\n",*mstart);
        else
          printf("\nAnalyze marker %d through marker %d\n",*mstart,*mstop);
        if (*dloc < *mstop)
           nmarks = *mstop-1;
        else if (*dloc > *mstop)
           nmarks = *dloc;
      }
    }
  }

  /* New code below for GASSOC version 1.06 */
  ok=1;
  while (ok) {
    printf("\nPerform GRR analysis? (Y/N)> ");
    fflush(stdin);
    rc=scanf("%c",&response);
    printf("\n");
    response=toupper(response);
    if ( (response=='Y' ) || (response=='N') ) {
      ok=0;
      if (response=='Y'){
         printf("\n\tWhich marker for GRR analysis? (%d - %d)>  ",*mstart,*mstop);
         fflush(stdin);
         rc=scanf("%d",&marker);
         printf("\n");
         printf("\n\tProvide label for GRR marker>  ");
         fflush(stdin);
         rc=scanf("%s",grrmarker);
         printf("\n");
         printf("\n\tWhich allele is of interest>  ");
         fflush(stdin);
         rc=scanf("%d",grrallele);
         printf("\n");         
         if (*dloc < *grrallele)
            ;
         else if (*dloc > *mstop)
            ;
         else{
            printf("Invalid entry disease: disease locus = locus of interest\n");
            ok=1;
	 }
         if (ok==0){
            for (i=0; i < nmarks; i++)
               add_word("NONAME",word_list,dlist_tail(word_list));
            element=dlist_head(word_list);

            i=1;

            if (marker > 1)
               marker=marker-1;

            while (1) {
               if (i==marker){
                   element->key_word = grrmarker;
                   break;
	       }
               
               if (dlist_is_tail(element))
                  break;
               else{
                  element=dlist_next(element);
                  i++;
		}  
	     
	     }
	  }
       }
    }
    /* New code above for GASSOC version 1.06 */
    else {
      printf("Invalid entry\n");
    }
  }

  ok=1;
  while (ok) {
    printf("\n# of simulations (0 if no simulations)>  ");
    fflush(stdin);
    rc=scanf("%i",sim);
    printf("\n");
    if ((*sim<0) || (rc==0)) 
      printf("Invalid entry\n");
    else {
      ok=0;
    }
  }

  if ((*sim) > 0) {
    printf("\nSeeds for random number generator (integer between 1 and 30,000):\n");

    ok=1;
    while (ok) {
      printf("Sseed 1>  ");
      fflush(stdin);
      rc=scanf("%i",seeda);
      printf("\n");
      if ((*seeda>30000) || (*seeda<1) || (rc==0)) 
        printf("Invalid entry\n");
      else 
        ok=0;
    }

    ok=1;
    while (ok) {
      printf("Seed 2>  ");
      fflush(stdin);
      rc=scanf("%i",seedb);
      printf("\n");
      if ((*seedb>30000) || (*seedb<1) || (rc==0)) 
        printf("Invalid entry\n");
      else 
        ok=0;
    }

    ok=1;
    while (ok) {
      printf("Seed 3>  ");
      fflush(stdin);
      rc=scanf("%i",seedc);
      printf("\n");
      if ((*seedc>30000) || (*seedc<1) || (rc==0)) 
        printf("Invalid entry\n");
      else 
        ok=0;
    }
    printf("Seeds for random # generation: %d %d %d\n",*seeda,*seedb,*seedc);


    if (*mstart==*mstop) {
 

      ok=1;
      while (ok) {
        printf("\nOutput simulated score statistics to a file? (Y/N)> ");
        fflush(stdin);
        rc=scanf("%c",&response);
        printf("\n");
        response=toupper(response);
        if ( (response=='Y') || (response=='N') )
          ok=0;
        else {
          printf("Invalid entry\n");
	}
      }

      if (response=='Y') {
        ok=1;
        while (ok) {
          printf("\nFile name for output> ");
          fflush(stdin);
          scanf("%25s",outfilename);
          printf("\n");
          if (strcmp(outfilename,infilename)==0) 
            printf("Invalid filename: outfile=infile\n");
          else {
            ok=0;
            *simout=1;
          }
        }
      }

      printf("\nBy default, the simulations test the null hypothesis: All betas=0.\n");
      ok=1;
      while (ok) {
        printf("Simulate under an alternative hypothesis? (Y/N)> ");
        fflush(stdin);
        scanf("%c",&response);
        printf("\n");
        response=toupper(response);
        if ( (response=='Y') || (response=='N') ) 
          ok=0;
        else 
          printf("Invalid response\n");
      }

      if (response=='Y') {
        ok=1;
        while (ok) {
          printf("\nNumber of distinct alleles for the marker> ");
          fflush(stdin);
          rc=scanf("%i",&nall);
          printf("\n");
          if ((rc==0) || (nall <= 0))
            printf("Invalid response\n");
          else  
            ok=0;
        }   
        vlen=(nall*(nall+1)/2)-1;      
        *bsim=vlen;
        betasim=dvector(vlen);  
        for (i=0;i<vlen;i++) { 
          ok=1;
          while (ok) {
            printf("\nEnter value %d for the beta vector>  ",i+1);
            fflush(stdin);
            rc=scanf("%lf",&num);
            printf("\n");
            if (rc==0)
              printf("Invalid response\n");
            else {
              ok=0;
              betasim[i]=num;
            }
          }
        }
        printf("\nBeta Vector:\n");
        for (i=0;i<vlen;i++) 
          printf("\nbetasim[%d]=%f\n",i,betasim[i]);
      }

    }
  }

  ok=1;
  while (ok) {
    printf("\nPrint iteration history? (Y/N)> ");
    fflush(stdin);
    scanf("%c",&response);
    printf("\n");
    response=toupper(response);
    if ( (response=='Y') || (response=='N') ) {
      ok=0;
      if (response=='Y')
        *iter=1;
      else
        *iter=0;
    }
    else 
      printf("Invalid response\n");
  }


  ok=1;
  while (ok) {
    printf("\nChange max. iterations for convergence(default=25)? (Y/N)>  ");
    fflush(stdin);
    scanf("%c",&response);
    printf("\n");
    response=toupper(response);
    if ( (response=='Y') || (response=='N') ) 
      ok=0;
    else 
      printf("Invalid response\n");
  }

  if (response=='Y') {
    ok=1;
    while (ok) {
      printf("\nNew maximum>  ");
      fflush(stdin);
      rc=scanf("%i",maxiter);
      printf("\n");
      if ( (rc==0) || (*maxiter<0) )
        printf("Invalid response\n");
      else 
        ok=0;
    }       
  }

  ok=1;
  while (ok) {
    printf("\nRedirect output from the screen to a file? (Y/N)>  ");
    fflush(stdin);
    scanf("%c",&response);
    printf("\n");
    response=toupper(response);
    if ( (response=='Y') || (response=='N') )  
      ok=0;
    else 
      printf("Invalid response\n");
  }

  *ofile=0;
  if (response=='Y') {
    *ofile=1;
    ok=1;
    while (ok) {
      printf("Name of output file>  ");
      fflush(stdin);
      scanf("%25s",outresults);
      printf("\n");
      if (strcmp(outresults,infilename)==0) 
        printf("Invalid filename: results file=input file\n");
      else { 
        if (strcmp(outresults,outfilename)==0) 
          printf("Invalid filename: results file=output score file\n");
        else
          ok=0;
      }
    }
  }
 
  return (betasim);
}




































