/*  SCCS     @(#)getindex.c	1.1    06/18/97     */
/*************************************************************************
*  Function     getindex()  
*
*  Purpose:     determine index to increment when coding allele vectors
*
*  Arguments:   long j                 index of allele to be coded
*               long baseline          index of baseline allele
*                            
*  Returns:     -1                         if j=baseline      
*                j                            j<baseline
*                j-1                          j>baseline
*             
*************************************************************************/

long getindex(long j,long baseline) {

long rc;

  if (j==baseline)
    rc=-1;
  else {
    if (j < baseline)
      rc=j;
    else
      rc=j-1;
  }

  return (rc);

}
    
