#include <stdio.h>
#include <math.h>
#include <string.h>
#include "cline.h"      /***Function to parse command line arguments***/
#include "geno.h"       /***Definition of genotype structure***/

/* New function below needed for GASSOC version 1.06 */

  /****************************DECLARATIONS***********************************/
  long   **l2g(int dloc, int nliab, int mloc,FILE *prefile,long *n_used,
               char *markername);
  double gammad(double x,double p,int *ifault);
  double alnorm(double x,int upper);
  long   *lvector(long n);
  double *dvector(long n);
  double **dmatrix(long nr, long nc);
  long   **lmatrix(long nr, long nc);   
  void   qksort(long *a,int first,int last);
  long   err_check(FILE *in,long *n_cases,long *n_pmiss,long *n_inc,
                   long *n_blank);
  int    ranAS183_seed(int iseed1, int iseed2, int iseed3);

  double log_likely(double *beta,long **x,long **x1,
                    long **x2,long **x3,long **x4,
                    long n_cases,long n_alleles);

  int max_like(long n_cases,long n_alleles,long maxiter,int iter,double *beta,
               long **x,long **x1,long **x2,long **x3,long **x4,
               double **v,double *logptr);

  void  score(double *score_tdt,double *score_dom,double *score_rec,
              double *pscore_tdt,double *pscore_dom,double *pscore_rec,
              int *rank_tdt,int *rank_dom,int *rank_rec,              
              long n_cases,long n_alleles,long **x,long **x1,long **x2,
              long **x3,long **x4);  

  void simsetup(double *betasim, long n_alleles,struct geno *indata,
              long **x1,long **x2,long **x3,long **x4,long n_cases, 
              double **psim,double **v_tdt , double *mtot_tdt,
              double **v_dom,double *mtot_dom,double **v_rec,double *mtot_rec);
            
  void simulate(double **psim,long n_alleles,long n_cases,
                long **x1,long **x2,long **x3,long **x4,
                double *mtot_tdt,double **v_tdt,double *simscore_tdt,
                double *mtot_dom,double **v_dom,double *simscore_dom,
                double *mtot_rec,double **v_rec,double *simscore_rec);

  long getindex(long j,long baseline);
  double *int_input(FILE **in,int *dloc,int *nliab,int *mstart,int *mstop,
                    int *iter,long *maxiter,long *sim,int *seeda,int *seedb,int *seedc,
                    int *simout,char *outfilename,int *bsim,int *ofile,char *outresults);

  void readpar(FILE *par,int *dloc,int *nliab,int *mstart,int *mstop);

  void tdtcode(long **x, long i, int baseline, int c1code, int c2code);

  void gencode(long **x, long i, int allele, int a1, int a2);

/*****************************************************************************/
 void compute_gen_or_tdt(char *word, struct geno *indata, long n_cases, 
                         long n_alleles, long ***y, long ***y1, long ***y2, 
                         long ***y3, long ***y4, long alleleofinterest, 
                         double *beta, long *unique_alleles, long grrallele,
                         long maxiter,int iter) 
{

  long   i,j,baseline,**x,**x1,**x2,**x3,**x4;

  double **v,**vprint,lnlold,lnl,lr_stat,lr_p;

  int  converge=0,rank_v,ifault;

  /*************************END DECLARATIONS**********************************/


/*---------------------------------------------------------------------------*/

      /**SET UP POINTERS FOR INDEXING MATRICES x, x1, x2, x3, x4***/
      *y =lmatrix(n_cases,n_alleles);
      *y1=lmatrix(n_cases,n_alleles);
      *y2=lmatrix(n_cases,n_alleles);
      *y3=lmatrix(n_cases,n_alleles);
      *y4=lmatrix(n_cases,n_alleles);

      x=*y;
      x1=*y1;
      x2=*y2;
      x3=*y3;
      x4=*y4;
 
      /***INITIALIZE 5 MATRICES OF DIMENSION[n_cases][n_alleles]***/
      for (i=0; i<n_cases; i++) {
        for (j=0; j<n_alleles; j++) {
          x[i][j] =0;
          x1[i][j]=0;
          x2[i][j]=0;
          x3[i][j]=0;
          x4[i][j]=0;
        }
      }

      /***VECTORS OF ITH CASE AND SET OF POSSIBLE VECTORS FOR ITH CASE   ***/
      /***   x: genotype of the ith case                                 ***/
      /***  x1,x2,x3,x4 set of possible genotypes from ith cases parents ***/
      for (i=0; i<n_cases; i++) {
        if (strcmp(word,"TDT") == 0){
           /***CHILD VECTOR***/
           tdtcode(x,i,alleleofinterest,indata[i].c1code,indata[i].c2code);

           /***POSSIBLE CHILD 1***/
           tdtcode(x1,i,alleleofinterest,indata[i].m1code,indata[i].f1code);

           /***POSSIBLE CHILD 2***/
           tdtcode(x2,i,alleleofinterest,indata[i].m1code,indata[i].f2code);

           /***POSSIBLE CHILD 3***/
           tdtcode(x3,i,alleleofinterest,indata[i].m2code,indata[i].f1code);

           /***POSSIBLE CHILD 4***/
           tdtcode(x4,i,alleleofinterest,indata[i].m2code,indata[i].f2code);
         } 
           else if (strcmp(word,"GRR") == 0){ 
           /***CHILD VECTOR***/
           gencode(x,i,alleleofinterest,indata[i].c1code,indata[i].c2code);

           /***POSSIBLE CHILD 1***/
           gencode(x1,i,alleleofinterest,indata[i].m1code,indata[i].f1code);

           /***POSSIBLE CHILD 2***/
           gencode(x2,i,alleleofinterest,indata[i].m1code,indata[i].f2code);

           /***POSSIBLE CHILD 3***/
           gencode(x3,i,alleleofinterest,indata[i].m2code,indata[i].f1code);

           /***POSSIBLE CHILD 4***/
           gencode(x4,i,alleleofinterest,indata[i].m2code,indata[i].f2code);
	 }
      }    

      /***ALLOCATE Beta VECTOR AND V MATRIX***/
      v=dmatrix(n_alleles,n_alleles);
      beta=dvector(n_alleles);
      for (i=0; i<n_alleles; i++)
        beta[i]=0;

      if (maxiter > 0) {

        /***CALCULATE INITIAL LOG-LIKELIHOOD***/
        lnl=lnlold=log_likely(beta,x,x1,x2,x3,x4,n_cases,n_alleles);

        /***ITERATE TO FIND MAXIMUM LIKELIHOOD***/
        converge=max_like(n_cases,n_alleles,maxiter,iter,beta,x,x1,x2,x3,x4,v,&lnl);
      } 
      else
        converge=0;


      /***PRINT SCORE STATISTIC AND MESSAGE IF IT DID NOT CONVERGE***/
      if (converge==0) {
        printf("  No Convergence after MAXITER=%d iterations\n",maxiter);
      }
  
      else {

        /***CALCULATE VAR(B) (v INVERSE)***/
        rank_v=cholesky2(v,n_alleles);
        chinv2(v,n_alleles);

        if (strcmp(word,"GRR") == 0)
           printf("\nGRR coding scheme\n");
        else if (strcmp(word,"TDT") == 0)
           printf("\nTDT coding scheme\n");

        /***PRINT FINAL ESTIMATES, REL RISK, SE, Z, PVAL***/
        printf("\nConditional Logistic:\n");

        printf("\n  Final estimates of Beta:\n\n");
        printf("                           Rel. Risk\n");

        if (strcmp(word,"TDT") == 0)
           printf("    Allele   Beta          exp(Beta)     SE(Beta)      Z         P(2-sided)\n");
        else if (strcmp(word,"GRR") == 0)
           printf("  Genetype   Beta          exp(Beta)     SE(Beta)      Z         P(2-sided)\n");

        for (i=0; i<n_alleles; i++) {
          if (strcmp(word,"TDT") == 0){
             if (i<alleleofinterest)
               printf("  %3d",unique_alleles[i]);
             else 
               printf("  %3d",unique_alleles[i+1]);
	   }
          else if (strcmp(word,"GRR") == 0) {
             if (i==0)
               printf("  %d|X",grrallele);
             else 
               printf("  %d|%d",grrallele,grrallele);
	   }
    
          if (v[i][i]<=0.0) {
           printf("   ***Unable to compute***\n");
	 }
          else {
            printf("  %12.4f",beta[i]);
            printf("  %12.4f",exp(beta[i]));
            printf("  %12.4f",sqrt(v[i][i]));
            printf("  %12.4f",beta[i]/sqrt(v[i][i]));
            printf("  %12.8f",2*(alnorm(fabs(beta[i]/sqrt(v[i][i])),1)));
            printf("\n"); 
          }
        }
          printf("\n");

        /***CALCULATE AND PRINT LIKELIHOOD RATIO STATISTIC***/
        lr_stat=2*(lnl-lnlold);
        lr_p=1-gammad(lr_stat/2.0,rank_v/2.0,&ifault);
        printf("  LR Statistic:    %15.4f,  df=%d,  p=%11.9f\n",lr_stat,rank_v,lr_p);

        /***CREATE AND PRINT VAR/COV MATRIX (UPPER TRIANGLE=CORRELATION ***/
        printf("\n  Covariance/Correlation Matrix (*=Corr(Bi,Bj)):\n");
        vprint=dmatrix(n_alleles,n_alleles);
        for (i=0; i< n_alleles; i++) {
          for (j=0; j< n_alleles; j++) {
            if (i==j) 
              vprint[i][j]=v[i][j];
            else {
              if (i>j)  
                vprint[i][j]=v[j][i];
              else { 
                vprint[i][j]=v[i][j]/sqrt(v[i][i]*v[j][j]);
              }
            }
            if (i<j)
              printf("  %15.4f*",vprint[i][j]);
            else
              printf("  %15.4f ",vprint[i][j]);
          }
          printf("\n");
        }
      }   
}
/*---------------------------------------------------------------------------*/












































