/*  SCCS     @(#)cline.c	1.1    06/18/97     */
/*****************************************************************
****   function: getflag(argc,argv,flag,vtype,val)
****
****   GET OPTIONS FROM COMMAND LINE:
****
****   returns: position of flag in argv on entry to function
****      note: arguments in argv change positions during function
****
*****************************************************************/
#define MFLEN 80

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int get_flag(int argc, char **argv, char *flag, int vtype, void *val) {
   int found, i, j, len, iv, negate, argnum;
   float fv;
   long  lv;
   double dv;
   char fs[MFLEN];
   char *argi;
   
   len = strlen(flag);
   if (!len) return 0;
   for (i=1; i<argc; i++) {
      argi = argv[i];
      if (argi[0] == '-') {
         if (argi[1]=='n' && argi[2]=='o') {
	   argi += 3;
	   negate = 1;
	 }
	 else {
	   argi++;
	   negate = 0;
	 }
         found = 1;
         for (j=0; j<len; j++) found = found && (argi[j] == flag[j]);
      } 
      else {
        found = 0;
      }
      if (found) {
         if (negate && vtype) return -1; 
         strcpy(fs, argi+len);
         switch (vtype){
            case 0:
               if (strlen(fs)>1) return -1;
	       if (strlen(fs)==0) {
	          *(int*)val = negate? 0 : 1;
                  goto tidyup;
	       }
               if (fs[0] ==  '+') {
	          *(int*)val = negate? 0 : 1;
                  goto tidyup;
	       }
               if (fs[0] ==  '-') {
	          *(int*)val = negate? 1 : 0;
                  goto tidyup;
	       }
               return -1;
            case 1:
               if (sscanf(fs, "%d", &iv)) {
                  *(int*)val = iv;
                  goto tidyup;
	       } else {
                  return -1;
	       }
            case 2:
               if (sscanf(fs, "%f", &fv)) {
                  *(float*)val = fv;
                  goto tidyup;
	       } else {
                  return -1;
	       }
            case 3:
               if (sscanf(fs, "%lf", &dv)) {
                  *(double*)val = dv;
                  goto tidyup;
	       } else {
                  return -1;
	       }
            case 4:
               if (!val) val = (char *) malloc(1+strlen(fs));
               strcpy((char*)val, fs);
               goto tidyup;
            case 5:
               if (sscanf(fs, "%d", &lv)) {
                  *(long*)val = lv;
                  goto tidyup;
	       } else {
                  return -1;
	       }
	 }
      }
   }
   return 0; /* Flag not found */

tidyup:
   argi = argv[i];
   argnum=i;
   for (;i < argc-1; i++) argv[i] = argv[i+1];
   argv[i] = argi;
   return argnum;   
}







