/*  SCCS     @(#)calc_uv.c	1.1    06/18/97     */
/***  Function:  calc_uv
****
****     Purpose: calculate the U vector and V matrix given XB
****
****     Returns: nothing
****              u and v will be updated upon return
****************************************************************************/
#include <math.h>
void calc_uv(long n_cases, long n_alleles,double *beta,
             double *u,double **v,long **x1,long **x2,
             long **x3,long **x4,long **x) {

long i,j,k;
double exponent1,exponent2,exponent3,exponent4,p1,p2,p3,p4,denom,*umean;
double *dvector(long n);

    umean=dvector(n_alleles);

    /***INITIALIZE V MATRIX AND U VECTOR***/
    for (i=0; i<n_alleles; i++) {
       for (j=0; j<n_alleles; j++) {
          v[i][j]=0;
 
       }
       u[i]=0;
    }

    /***DO FOR EACH CASE***/
    for (i=0; i<n_cases; i++) {

       /***CALCULATE (x*')B***/
       exponent1=exponent2=exponent3=exponent4=0;

       for (j=0; j<n_alleles; j++) {
          exponent1+=x1[i][j]*beta[j];
          exponent2+=x2[i][j]*beta[j];
          exponent3+=x3[i][j]*beta[j];
          exponent4+=x4[i][j]*beta[j];     
       }

       /***CALCULATE exp((x*')B)****/
       p1=exp(exponent1);
       p2=exp(exponent2);
       p3=exp(exponent3);
       p4=exp(exponent4);

       /***CALCULATE SUM OF exp((x*')B) over 4 possible genotypes***/
       denom=p1+p2+p3+p4;
     
       /***CALCULATE p FOR EACH POSSIBLE GENOTYPE***/
       p1=p1/denom;
       p2=p2/denom;
       p3=p3/denom;
       p4=p4/denom;

       /***CALCULATE U VECTOR***/
       for (j=0; j<n_alleles; j++) {
         umean[j]=(x1[i][j]*p1+x2[i][j]*p2+x3[i][j]*p3+x4[i][j]*p4);
         u[j]+=(x[i][j]-umean[j]);
       }

       /***CALCULATE V MATRIX***/
       for (j=0; j<n_alleles; j++) { 
          for (k=0; k<n_alleles; k++) {
             v[j][k]+= ((x1[i][j]*x1[i][k]*p1 +
                         x2[i][j]*x2[i][k]*p2 +
                         x3[i][j]*x3[i][k]*p3 +
                         x4[i][j]*x4[i][k]*p4 ) - (umean[j]*umean[k]));
           
	  }
       }
    }
}















