/*  SCCS     @(#)as66.c	1.1    06/18/97     */
/***
****       Algorithm AS66 Applied Statistics (1973) vol22 no.3
****
****       Evaluates the tail area of the standardised normal curve
****       from x to infinity if upper is .true. or
****       from minus infinity to x if upper is .false.
****
****       Converted from fortran to C.
***/

#include <math.h>

double alnorm(double x,int upper) {

        double z,y;
        double norm;
        int up;

/***machine dependent constants***/
#define zero 0.0
#define one  1.0
#define half 0.5
#define ltone 7.0
#define utzero 18.66
#define con  1.28
#define p 0.398942280444
#define q 0.39990348504
#define r 0.398942280385
#define a1 5.75885480458
#define a2 2.62433121679
#define a3 5.92885724438
#define b1 -29.8213557807
#define b2 48.6959930692
#define c1 -.000000038052
#define c2 .000398064794
#define c3 -0.151679116635
#define c4 4.8385912808
#define c5 0.742380924027
#define c6 3.99019417011  
#define d1 1.00000615302
#define d2 1.98615381364
#define d3 5.29330324926  
#define d4 -15.1508972451
#define d5 30.789933034

      up=upper;
      z=x;
      if (z >= zero) goto l10;
      up=!up;
      z=-z;

l10:  if ( (z <= ltone) || up && (z <= utzero) ) goto l20;
      norm=zero;
      goto l40;

l20:  y=half*z*z;
      if (z > con) goto l30;
      norm=half-z*(p-q*y/(y+a1+b1/(y+a2+b2/(y+a3))));
      goto l40;

l30:   norm=r*exp(-y)/(z+c1+d1/(z+c2+d2/(z+c3+d3/(z+c4+d4/(z+c5+d5/(z+c6))))));

l40:   if (!up) norm=one-norm;
      return norm;

}






















