/*  SCCS     @(#)as239.c	1.2    06/18/97     */
/**
***	ALGORITHM AS239  APPL. STATIST. (1988) VOL. 37, NO. 3
***
***	Computation of the Incomplete Gamma Integral
***
***	Auxiliary functions required: ALOGAM = logarithm of the gamma
***	function, and ALNORM = algorithm AS66
***
***     Converted from FORTRAN to C.
**/

#include <math.h>

double  gammad(double x,double  p,int *ifault) {

	double  pn1, pn2, pn3, pn4, pn5, pn6, 
     	        arg, c, rn, a, b, an, gam;

#define	ZERO 0.0
#define ONE  1.0
#define TWO  2.0 
#define OFLO 1.0e37
#define THREE 3.0
#define NINE  9.0
#define TOL  1.0e-14
#define XBIG  1.0e8
#define PLIMIT 1000.0 
#define ELIMIT -88.0

#define MIN(x,y) ((x)<=(y) ? (x) : (y))

double alngam(double xvalue,int *ifault);
double alnorm(double x,int upper); 


	gam = ZERO;
/*
**	Check that we have valid values for X and P
*/

	if (p <= ZERO || x < ZERO) {
	  *ifault = 1;
	  return gam;
	}
	*ifault = 0;
	if (x == ZERO) return gam;
/*
**	Use a normal approximation if P > PLIMIT
*/
	if (p > PLIMIT) {
          pn1 = THREE * sqrt(p) * (pow((x / p),(ONE / THREE)) + ONE /
     		(NINE * p) - ONE);
	  gam = alnorm(pn1,0);
	  return gam;
	}
/*
**	If X is extremely large compared to P then set GAMMAD = 1
*/
	if (x > XBIG) {
	  gam = ONE;
	  return gam;
	}

	if (x <= ONE || x < p) {
/*
**	Use Pearson's series expansion.
**	(Note that P is not large enough to force overflow in ALOGAM).
**	No need to test IFAULT on exit since P > 0.
*/
	  arg = p * log(x) - x - alngam(p + ONE, ifault);
	  c = ONE;
	  gam = ONE;
	  a = p;
   l40:	  a = a + ONE;
	  c = c * x / a;
	  gam = gam + c;
	  if (c > TOL) goto l40;
	  arg = arg + log(gam);
	  gam = ZERO;
	  if (arg >= ELIMIT) gam = exp(arg);
        }
	  else {
/*
**	Use a continued fraction expansion
*/
	  arg = p * log(x) - x - alngam(p, ifault);
	  a = ONE - p;
	  b = a + x + ONE;
	  c = ZERO;
	  pn1 = ONE;
	  pn2 = x;
	  pn3 = x + ONE;
	  pn4 = x * b;
	  gam = pn3 / pn4;
   l60:	  a = a + ONE;
	  b = b + TWO;
	  c = c + ONE;
	  an = a * c;
	  pn5 = b * pn3 - an * pn1;
	  pn6 = b * pn4 - an * pn2;
	  if (fabs(pn6) > ZERO) {
	    rn = pn5 / pn6;
	    if (fabs(gam - rn) <= MIN(TOL, TOL * rn)) goto l80;
	    gam = rn;
          }

	  pn1 = pn3;
	  pn2 = pn4;
	  pn3 = pn5;
	  pn4 = pn6;
	  if (fabs(pn5) >= OFLO) {
/*
**	Re-scale terms in continued fraction if terms are large
*/
	    pn1 = pn1 / OFLO;
	    pn2 = pn2 / OFLO;
	    pn3 = pn3 / OFLO;
	    pn4 = pn4 / OFLO;
	  }
	  goto l60;
   l80:	  arg = arg + log(gam);
	  gam = ONE;
	  if (arg >= ELIMIT) gam = ONE - exp(arg);
	}

	return gam;
}








