#include "dlistheader.h"

/* New function for GASSOC version 1.06 */

/*----------------------------------------------------------------------*/
/*  Pre- word cannot be NULL.                                              */
/* Post- word is added to the linked list word_list in the key_word field. */

int
add_word(const void *key_word,DList *word_list, DListElmt *element)
{
DListElmt          *new_element;



/*****************************************************************************
*                                                                            *
*  Do not allow a NULL element unless the list is empty.                     *
*                                                                            *
*****************************************************************************/

if (element == NULL && dlist_size(word_list) != 0)
   return -1;

/*****************************************************************************
*                                                                            *
*  Allocate storage for the element.                                         *
*                                                                            *
*****************************************************************************/

if ((new_element = (DListElmt *)malloc(sizeof(DListElmt))) == NULL)
   return -1;

/*****************************************************************************
*                                                                            *
*  Insert the new element into the list.                                     *
*                                                                            *
*****************************************************************************/
new_element->key_word = (void *)key_word;

if (dlist_size(word_list) == 0) {

   /**************************************************************************
   *                                                                         *
   *  Handle insertion when the list is empty.                               *
   *                                                                         *
   **************************************************************************/

   word_list->head = new_element;
   word_list->head->prev = NULL;
   word_list->head->next = NULL;
   word_list->tail = new_element;

   }

else {

   /**************************************************************************
   *                                                                         *
   *  Handle insertion when the list is not empty.                           *
   *                                                                         *
   **************************************************************************/

   new_element->next = element->next;
   new_element->prev = element;

   if (element->next == NULL)
      word_list->tail = new_element;
   else
      element->next->prev = new_element;

   element->next = new_element;

}

/*****************************************************************************
*                                                                            *
*  Adjust the size of the list to account for the inserted element.          *
*                                                                            *
*****************************************************************************/

word_list->size++;

return 1;


}
