# When Statsci gets the plot methods out for timeDate objects, I expect
#  them to be better, and we'll just call that method

# For now-- if the user has given an xaxt arg, obey them, otherwise
#   put in my rough method for a date axis

setMethod('plot', signature(x='date', y='ANY'),
    function(x,y, ...) plotdate1(x,y,...))
setMethod('plot', signature("ANY", 'date'), 
    function(x,y, ...) plotdate2(x,y,...))
setMethod('plot', signature('date','date'), 
    function(x,y, ...) plotdate3(x,y,...))
 
plotdate3 <- function(x, y, ..., xaxt, yaxt, xlab, ylab) {
	if (missing(xlab)) xlab <- deparse(substitute(x))
	if (missing(ylab)) ylab <- deparse(substitute(y))
	if (missing(xaxt)) {
	    if (missing(yaxt)) {
		plot(x@.Data, y@.Data, ..., xaxt='n', yaxt= 'n', ...,
		      xlab=xlab, ylab=ylab)
		axis.date(1, x)
		axis.date(2, y)
		}
	    else {
		plot(x@.Data, y@.Data, ..., xaxt='n', yaxt= yaxt, ...,
		      xlab=xlab, ylab=ylab)
		axis.date(1, x)
		}
	    }
	else {
	    if (missing(yaxt)) {
		plot(x@.Data, y@.Data, ..., xaxt=xaxt, yaxt= 'n', ...,
		      xlab=xlab, ylab=ylab)
		axis.date(2, y)
		}
	    else {
		plot(x@.Data, y@.Data, ..., xaxt=xaxt, yaxt= yaxt, ...,
		      xlab=xlab, ylab=ylab)
		}
	    }
	}



plotdate1 <- function(x,y, ..., xaxt, xlab, ylab) {
    if (missing(xlab)) xlab <- deparse(substitute(x))
    if (missing(ylab)) ylab <- deparse(substitute(y))
    if (missing(xaxt)) {
	plot(x@.Data, y, ..., xaxt='n',  ...,
		      xlab=xlab, ylab=ylab)
	axis.date(1, x)
	}
    else plot(x@.Data, y, ..., xaxt=xaxt, ...,
		      xlab=xlab, ylab=ylab)
    }

plotdate2 <-    function(x,y, ..., yaxt, xlab, ylab) {
    if (missing(xlab)) xlab <- deparse(substitute(x))
    if (missing(ylab)) ylab <- deparse(substitute(y))
    if (missing(yaxt)) {
	plot(x, y@.Data, ..., yaxt='n',  ...,
	     xlab=xlab, ylab=ylab)
	axis.date(2, y)
	}
    else plot(x, y@.Data, ..., xaxt=xaxt, ...,
		      xlab=xlab, ylab=ylab)
    }




axis.date <- function(side=1, x) {
    x <- x[!is.na(x)]

    xd<- date.mdy(x)
    temp <- pretty(x@.Data, 5)
    delta <- temp[2] - temp[1]
    if (delta <1)
	    temp <- seq(min(x), max(x), 1)
    else if (delta > 182) {   #try to do it in years
	temp <- xd$year + (x - mdy.date(1,1,xd$year))/365
	temp <- pretty(temp,5)
	temp <- mdy.date(1, 1, floor(temp)) + floor((temp%%1)*365)
	temp <- temp@.Data
	}

    xlim <- par("usr")[2*side - 1:0]
    temp <- temp[temp>xlim[1] & temp<xlim[2]]
    if (side==1) axis(side, temp, format(as(temp, 'date')))
    else { # work around a bug: srt/crt aren't forgotton
        axis(side, temp, format(as(temp, 'date')), srt=90, crt=90)
	axis(side, temp[1], "", srt=0, crt=0)
	}
    }
