#
as.date <- function(x, order='mdy', ...) {
    if (inherits(x, "date")) x
    else if (is.character(x)) {
	order.vec <- switch(order,
				  'ymd'= c(1,2,3),
				  'ydm'= c(1,3,2),
				  'mdy'= c(2,3,1),
				  'myd'= c(2,1,3),
				  'dym'= c(3,1,2),
				  'dmy'= c(3,2,1),
				   stop("Invalid value for 'order' option"))
	nn <- length(x)
	temp <- .C("char_date", as.integer(nn),
				  as.integer(order.vec),
				  as.character(x),
				  month=integer(nn),
				  day = integer(nn),
				  year= integer(nn))

	month <- ifelse(temp$month<1 | temp$month>12, NA, temp$month)
	day   <- ifelse(temp$day==0, NA, temp$day)
	year  <- ifelse(temp$year==0, NA, temp$year)

	temp <- mdy.date(month, day, year, ...)
	}
    else if (is.numeric(x)) temp <- as(as(x, 'numeric'), 'date')
    else stop("Cannot coerce to date format")
    temp
    }
