# New S functions for dates
setClass("date", 
	 representation("integer", format='character'))

setAs("numeric", "date", 
      function(object) new("date", .Data=floor(object)))

setAs('character', 'date',
      function(object) as.date(object))

setAs('date', 'timeDate',
         function(object) {
	     if (length(object@format)>0) 
		     timeDate(julian=object@.Data, format=object@format)
	     else timeDate(julian=object@.Data)
	     }
      )

setAs('timeDate', 'date',
	function(object) {
		new('date', .Data=(object@.Data)[[1]], 
	                     format=object@format)
	})

setMethod('[', 'date', function(x, ..., drop = T) {
    x@.Data <- x@.Data[..., drop=drop]
    x
    })

setMethod('range', 'date', function(x, ..., na.rm=F) {
    x@.Data <- range(x@.Data, na.rm=na.rm)
    x})
setMethod('max', 'date', function(x, ..., na.rm=F) {
    x@.Data <- max(x@.Data, na.rm=na.rm)
    x})
setMethod('min', 'date', function(x, ..., na.rm=F) {
    x@.Data <- min(x@.Data, na.rm=na.rm)
    x})
setMethod('sort', 'date', function(x, partial=NULL, na.last=NA) {
    x@.Data <- sort(x@.Data, partial=partial, na.last=na.last)
    x})

setMethod('+', signature(e1='date', e2='numeric'),
	  function(e1,e2) {
	      e1@.Data <- e1@.Data + round(e2)
	      e1
	      })

setMethod('-', signature(e1='date', e2='numeric'),
	  function(e1,e2) {
	      e1@.Data <- e1@.Data - round(e2)
	      e1
	      })

setMethod('+', signature(e1='numeric', e2='date'),
	  function(e1,e2) {
	      e2@.Data <- e2@.Data + round(e1)
	      e2
	      })

setMethod("-", signature(e1='date', e2='date'),
	  function(e1, e2) e1@.Data - e2@.Data)


setMethod("concat.two", c("date", "date"),                
	  function(x,y) {
	      x@.Data <- concat.two(x@.Data, y@.Data)
	      x
	      })

setMethod('is.na', 'date', function(x) is.na(x@.Data))	  


