#
#  Return the month, day, and year given a julian date
#
date.mdy <- function(date, weekday=F) {
    sdate <- as(date, 'integer')
    sdate <- sdate + 2436935  #From SAS to Num Recipies base point
    wday <- as.integer((sdate+1)%%7 +1)
    temp <- ((sdate-1867216) -.25) / 36524.25
    sdate <- ifelse(sdate >=2299161, trunc(sdate+1+temp -trunc(.25*temp)),
				       sdate)
    jb <- sdate + 1524
    jc <- trunc(6680 + ((jb-2439870)-122.1)/365.25)
    jd <- trunc(365.25 * jc)
    je <- trunc((jb-jd)/ 30.6001)
    day <- (jb - jd) - trunc(30.6001*je)
    month <- as.integer(ifelse(je>13, je-13, je-1))
    year  <- as.integer(ifelse(month>2, jc-4716, jc-4715))
    year  <- as.integer(ifelse(year <=0, year-1, year))
    if (weekday) list(month=month, day=day, year=year, weekday=wday)
    else         list(month=month, day=day, year=year)
    }
