\name{ibd.peaks}
\alias{ibd.peaks}
\title{
  Find positions corresponding to ibd sharing peaks
}
\description{
Find positions corresponding to ibd sharing peaks
}
\usage{
ibd.peaks(pos, ibd, top.pct=0.4, end.cut=10, near.rng=10)
}
\arguments{

\item{pos}{
Vector of chromosome positions, in centimorgans
}
\item{ibd}{
Vector of mean ibd sharing values
}
\item{top.pct }{
In selecting tau starting values, only consider the
positions whose mean allele sharing is in the top.pct*100 percent
}
\item{end.cut }{
Do not select a tau starting value within end.cut centimorgans from
the end
}
\item{near.rng}{
The minimum range, in centimorgans, that a separate IBD sharing peak
may be detected.  All clusters of IBD sharing peaks consecutively within
near.rng cM of each other, will provide one starting value for tau. 
}
}
\value{
If peaks found, a vector of positions (pos) where those peaks occur.  NA otherwise.
}
\section{Side Effects}{

}
\details{
Evaluate the best canditate positions for ibd sharing peaks by three criteria.
1) Select candidates from points in the top top.pct*100 percent of the ibd
range. 2) Exclude positions within end.cut cM of the ends, as the
estimation of a peak in those regions is unstable. 3) For all positions
meeting the first two criteria, of the ibd sharing peaks approximated
as having 2nd derivatives less than zero, find clusters of those which are
consecutively within near.rng centimorgans of each other.  Choose the
point within the cluster with the highest ibd sharing peak.  
}
\section{References}{

}
\seealso{
\code{\link{arp.ibd}}
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
