\name{arp.ibd.fitter}
\alias{arp.ibd.fitter}
\title{
  For internal use within arp.ibd.
}
\description{
For internal use within arp.ibd.
}
\usage{
arp.ibd.fitter(ibd.obj, model="C", tau.init=NA, c.init=NA, lambda.init=NA,
ci.prob=0.95, max.iter=50, tol=0.0001, eps=1, print.iter=FALSE)
}
\arguments{
\item{ibd.obj }{
An object of the 'ibd.share' class, a list which contains the
following elements: \$smat - a matrix having allele sharing probabilities
for affected relative pairs (rows) at each position (columns) of a 
chromosomal region; \$type - vector of affected relative pair types;
\$ped - vector of pedigree id's; and \$pos - vector of chromosome positions (in
centimorgans) matching the columns of \$smat.
}
\item{model}{
Character string with either 'C' for C-coefficients or 'Lambda', which
constrains all C's to be a function of a single lambda.
}
\item{tau.init }{
Chromosome position initial value.  If none is given, the default is the 
position with the largest mean allele sharing.
}
\item{c.init }{
Vector of C-coefficients, one for each ARP type.  If c.init=NA,
each element is estimated from the ibd sharing data for the relevant
ARP type by setting tau=tau.init and using least squares.
}
\item{lambda.init }{
Initial value for lambda parameter under model='Lambda'.  If not
given, then the C's are initialized as described under
c.init; these are transformed into lambdas, and the weighted average
of these is used as the initial value.
}
\item{ci.prob }{
Probability level for constructing confidence intervals for the
parameters.
}
\item{max.iter }{
Maximum iterations allowed in Newton-Raphson steps
}
\item{tol}{
Convergence tolerance for changes in scores and parameters from previous iteration
}
\item{eps}{
Epsilon, smoothing adjustment constant from Liang et al.(2001), as
used for adjustment within the Haldane mapping function.  
}
\item{print.iter }{
Logical, if TRUE, causes print of u-scores, gamma, and info-mat after
each Newton-Raphson iteration.
}
}
\value{
A list to be made into an arp.ibd object by the arp.ibd function.
}
\section{Side Effects}{

}
\details{

}
\section{References}{
Liang K-Y, Chiu Y-F, Beaty, TH (2001).  A robust identity-by-descent
procedure using affected sib pairs:  Multipoint mapping for complex
diseases.  Hum Hered 51:64-78.

Schaid DJ, Sinnwell JP, Thibodeau SN (2004). Robust Multipoint
Identical-by-Descent Linkage Mapping with Affected Relative Pairs.  Submitted.
}
\seealso{
\code{\link{arp.ibd}}
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 1.21.
