#!/usr/local/bin/perl
#$Author: schaid $
#$Date: 2003/01/17 14:49:34 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/parse.genehunter.ibd.pl,v 1.2 2003/01/17 14:49:34 schaid Exp $
#$Locker:  $
#$Log: parse.genehunter.ibd.pl,v $
#Revision 1.2  2003/01/17 14:49:34  schaid
#print format of per1 and per2 changed from real to string
#
#Revision 1.1  2003/01/15 16:30:46  schaid
#Initial revision
#

# Convert GENEHUNTER ibd output file to a structured file that can be input
# to Splus

$filein  = @ARGV[0];

$nrec = 0;

open (FILEIN,  $filein ) || die "Input  fild could not be opened\n";

while(<FILEIN>){
    chomp;	# strip record separator
    @Fld = split(' ', $_, 9999);

    # Found header line
    if($Fld[0]=~ /pos/){
       next;
     }
     $nrec++;
     $pos[$nrec]=$Fld[0];
     $ped[$nrec]=$Fld[1];
     ($p1,$p2) = split(",",$Fld[2],2);
     $per1[$nrec]=$p1;
     $per2[$nrec]=$p2;
     $prior0[$nrec]=$Fld[3];
     $prior1[$nrec]=$Fld[4];
     $prior2[$nrec]=$Fld[5];
     $post0[$nrec]=$Fld[6];
     $post1[$nrec]=$Fld[7];
     $post2[$nrec]=$Fld[8];

  }

print "s.class genehunter.ibd\n";
print "s.matrix ibd $nrec 10 ped pos per1 per2 prior0 prior1 prior2 post0 post1 post2\n";

$rec=0;
printf("%s %7.3f %s %s %12.6f %12.6f %12.6f %12.6f %12.6f %12.6f\n",
   $ped[$rec],$pos[$rec],$per1[$rec],$per2[$rec],$prior0[$rec],$prior1[$rec],
   $prior2[$rec],$post0[$rec],$post1[$rec],$post2[$rec])  while $rec++ < $nrec;
