#$Author: sinnwell $
#$Date: 2005/04/06 19:25:15 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/manualARPgee.q,v 1.1 2005/04/06 19:25:15 sinnwell Exp $
#$Locker:  $
#$Log: manualARPgee.q,v $
#Revision 1.1  2005/04/06 19:25:15  sinnwell
#Initial revision
#
###################################################
### chunk number 1: 
###################################################
 cat("## If local library use:\n\t## library(arp.gee, lib.loc=\"/full/local/path/\")")


###################################################
### chunk number 2: 
###################################################
#If you have a local library, use 
#library(arp.gee, lib.loc=path/in/quotes)

# otherwise load the arp.gee library
library(arp.gee)


###################################################
### chunk number 3: 
###################################################
# set width option for the whole document
options(width=60)


###################################################
### chunk number 4: 
###################################################
# Load the output from Genehunter into the session.  This may take a while 
# then show a summary of the ibd.share object 
# %MUST COPY ALL OF THE GH.EXAMPLE.* FILES INTO THE WORKING DIRECTORY, 
# %THEY ARE LOCATED IN ~/arp.gee/exec 
example.share <- ibd.share.genehunter(ibd.file = "gh.example.ibd.out", 
                       pre.file = "gh.example.pre", min.pairs = 20)


###################################################
### chunk number 5: 
###################################################
# if all else fails, read in a 'dump'ed version of example.share 
setupData(example.share)


###################################################
### chunk number 6: 
###################################################
names(example.share)


###################################################
### chunk number 7: 
###################################################
# show a summary of example.share, gives table of ARP types
#     the number of chrom positions and pedigrees
summary(example.share)


###################################################
### chunk number 8: 
###################################################
# now look at a plot of the ibd data 
plot(example.share) 


###################################################
### chunk number 9: 
###################################################
# Fit the model-C, using defaults for optional parameters. 
fit.c <- arp.ibd(example.share, model="C") 
# To view results, type the name of the saved object, 
fit.c 


###################################################
### chunk number 10: 
###################################################
# view a summary, which includes details of the fit from each starting value 
summary(fit.c) 


###################################################
### chunk number 11: 
###################################################
# now look at a plot of the fitted line
# to compare with mean sharing, also pass example.share object 
plot(fit.c, example.share)


###################################################
### chunk number 12: 
###################################################
# Fit the model-Lambda, using defaults for optional parameters
fit.lambda <- arp.ibd(example.share, model="lambda") 
print(fit.lambda)


###################################################
### chunk number 13: 
###################################################
# now look at a plot of the fit
plot(fit.lambda)


###################################################
### chunk number 14: 
###################################################
stat.equal <- lambda.equal.arp(example.share, fit.lambda) 
unlist(stat.equal) 


###################################################
### chunk number 15: 
###################################################
# Full-sibs subset analyses 
example.fs  <- example.share 
fs <- example.share$type=="FS" 
example.fs$smat <- example.fs$smat[fs,] 
example.fs$ped <- example.fs$ped[fs] 
example.fs$type <- example.fs$type[fs] 
 
save.fs <- arp.ibd(example.fs, model="C") 
save.fs 
 


###################################################
### chunk number 16: 
###################################################
# First-Cousin subset analyses 
example.fc  <- example.share 
fc <- example.share$type=="FC" 
example.fc$smat <- example.fc$smat[fc,] 
example.fc$ped <- example.fc$ped[fc] 
example.fc$type <- example.fc$type[fc] 
 
save.fc <- arp.ibd(example.fc, model="C", tau.init=c(30,60,90)) 
summary(save.fc) 


###################################################
### chunk number 17: 
###################################################
# Avuncular subset analyses 
example.av  <- example.share 
av <- example.share$type=="AV" 
example.av$smat <- example.av$smat[av,] 
example.av$ped <- example.av$ped[av] 
example.av$type <- example.av$type[av] 
 
save.av <- arp.ibd(example.av, model="C") 
save.av 


###################################################
### chunk number 18: 
###################################################
# try different starting values to make this converge.   
save.av.init <- arp.ibd(example.av, model="C", tau.init=c(30,90,60)) 
save.av.init


###################################################
### chunk number 19: 
###################################################
# view the summary table, not an estimate for tau.init=90 because non-convergence 
save.av.init$summary.df 


###################################################
### chunk number 20: 
###################################################
# now look at a plot of the fit 
plot(save.av.init, example.av) 


