#$Author: sinnwell $
#$Date: 2005/01/13 15:35:46 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/read.objects.q,v 1.2 2005/01/13 15:35:46 sinnwell Exp $
#$Locker:  $
#$Log: read.objects.q,v $
#Revision 1.2  2005/01/13 15:35:46  sinnwell
#T to TRUE
#
#Revision 1.1  2003/01/15 16:31:25  schaid
#Initial revision
#
read.objects <- function(file){

# Title: Generic function to read a file with "s" tags, then finish with class method

is.s.tag <- function(y){

   # Title: Check whether y contains an s.tag

   check <- charmatch(as.character(y),c("s.class","s.matrix","s.vector"))
   return(any(!is.na(check)))

}

name.items <- NULL
class.defined <- F
item.list <- 0
x.list <- list(NULL)
i.start <- 1
i.stop <- 1

x <- scan(file,what="")
x.length <- length(x)

while(i.start < x.length){

   obj.int <- charmatch(x[i.start],c("s.class","s.matrix","s.vector"))

   if(is.na(obj.int)) stop(paste("s.tag expected but not found:",x[i.start]))

   switch(obj.int,

    { # process class of data, according to s.class from input file

      if(class.defined) stop("More than 1 s.class in file is not allowed")

      item.list <- item.list + 1
      i.start <- i.start + 1
      x.list[[item.list]] <- x[i.start]
#      names(x.list[item.list]) <- "s.class"
      name.items <- c(name.items,"s.class")

      i.start <- i.start + 1
      class.defined <- T
    },

    { # process a matrix object
      item.list <-  item.list + 1
      i.start <- i.start + 1
      x.name <- x[i.start]

      if(is.s.tag(x.name)) 
         stop(paste("s.tag for name of matrix is invalid:",x.name))

      i.start <- i.start+1
      n.row <- as.numeric(x[i.start])

      if(is.s.tag(n.row)) 
         stop(paste("s.tag for n.row of matrix is invalid:",n.row))

      i.start <- i.start + 1
      n.col <- as.numeric(x[i.start])

      if(is.s.tag(n.col)) 
         stop(paste("s.tag for n.col of matrix is invalid:",n.col))

      i.start <- i.start + 1
      i.stop <- i.start + n.col - 1
      header <- x[i.start:i.stop]


      if(is.s.tag(header)) 
         stop(paste("s.tag for header of matrix is invalid:",header))

      i.start <- i.stop + 1
      i.stop <- i.stop + n.row*n.col

      if( (x.length-i.start + 1 ) <  n.row*n.col )
         stop(paste("Not enougth items remain to fill matrix: ",x.name))


      if(is.s.tag(x[i.start:i.stop]))
         stop(paste("s.tag for matrix item not valid. Matrix name =",x.name))

      x.list[[item.list]] <- matrix(x[i.start:i.stop], ncol=n.col, byrow=TRUE)
#      names(x.list[item.list]) <- x.name
      name.items <- c(name.items,x.name)

      dimnames(x.list[[item.list]]) <- list(1:nrow(x.list[[item.list]]), header)
      i.start <- i.stop + 1
      invisible()
    }, 

   { # process a vector object
      item.list <-  item.list + 1
      i.start <- i.start + 1
      x.name <- x[i.start]

      if(is.s.tag(x.name)) 
         stop(paste("s.tag for name of vector is invalid:",x.name))


      i.start <- i.start + 1
      vec.length <- as.numeric(x[i.start])

     if(is.s.tag(vec.length)) 
         stop(paste("s.tag for length of vector is invalid:",vec.length))


      i.start <- i.start + 1
      i.stop <- i.start + vec.length - 1

      if( (x.length-i.start + 1 ) <  vec.length )
         stop(paste("Not enougth items remain to fill vector: ",x.name))

      if(is.s.tag(x[i.start:i.stop]))
         stop(paste("s.tag for vector item not valid. Vector name =",x.name))


      x.list[[item.list]] <- x[i.start:i.stop]
#      names(x.list[item.list]) <- x.name
       name.items <- c(name.items,x.name)
#cat("list name = ", names(x.list[item.list]),"\n")
      i.start <- i.stop + 1
    }
  )

}

# Now finish processing object by appropriate data conversions
# and setup that depend on the data source

names(x.list) <- name.items

if(class.defined){
   oldClass(x.list) <- x.list$s.class
}

x.list <- finish.objects(x.list)


return(x.list)



}
