#$Author: sinnwell $
#$Date: 2005/01/13 16:05:23 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/lambda.equal.arp.q,v 1.3 2005/01/13 16:05:23 sinnwell Exp $
#$Locker:  $
#$Log: lambda.equal.arp.q,v $
#Revision 1.3  2005/01/13 16:05:23  sinnwell
#deriv.c2lambda call is now derivC2lambda
#
#Revision 1.2  2004/10/19 21:42:18  sinnwell
#levels=levels=c( fixed
#
#Revision 1.1  2004/10/07 21:52:23  sinnwell
#Initial revision
#
lambda.equal.arp <- function(ibd.obj, fit.lambda){

  eps <- fit.lambda$eps
  tau <- fit.lambda$gamma[1]
  lambda <- fit.lambda$gamma[2]

# type is factor, make integer version and counts of used types
  type <- factor(ibd.obj$type, levels=c("FS","HS","FC","GP","AV"))
  
# make index vectors which to subset on if any na's
  zed.rows <- is.na(type) | is.na(ibd.obj$ped) | apply(is.na(ibd.obj$smat), 1, any)

  type <- type[!zed.rows]
  
# subset rows(pairs) and columns (positions) from missings
# then order by type (not by ped id) 
  ord <- order(type)
  smat <- ibd.obj$smat[!zed.rows,][ord,]
  ped <- ibd.obj$ped[!zed.rows][ord]
  type <- type[ord]
  pos <- ibd.obj$pos  
  nPos <- length(pos)
  pedIndx <- as.numeric(factor(ped))-1
  nPed <- length(unique(pedIndx))

  n.type <- table(type)
  utype <- unique(type)
  int.type <- as.integer(utype)

  n.utype <- length(int.type)
  c.coef <- numeric(n.utype)


  for(i in 1:n.utype){
    c.coef[i] <- lambda2c(int.type[i], lambda=lambda)
  }


  gamma <- c(tau, c.coef)
  n.gamma <- length(gamma)

  max.iter <- 0
  tol <- 1e-4
  verbose <- 0

  save <-  .C("gee_arp",
             pos=as.double(pos),         
             n.pos=as.integer(nPos), 
             Svec=as.double(as.vector(smat)), 
             n.pair=as.integer(nrow(smat)),   
             pedIndx=as.integer(pedIndx),
             nPed=as.integer(nPed),
             type=as.integer(int.type),          
             len.type=as.integer(length(int.type)),
             n.type=as.integer(n.type[int.type]),       
             iter=as.integer(0),
             max.iter=as.integer(max.iter),
             tol=as.double(tol),
             eps=as.double(eps), 
             u.scores=as.double(rep(0,n.gamma)),
             gamma = as.double(gamma),
             n.gamma =as.integer(n.gamma),
             info.vec = as.double(numeric(n.gamma*n.gamma)),     
             info.robust.vec = as.double(numeric(n.gamma*n.gamma)),
             rank=as.integer(n.gamma),
             converge=as.integer(0),
             alias=as.integer(numeric(n.gamma)),
             verbose=as.integer(verbose),
             PACKAGE='arp.gee')


  save$info.robust <- matrix(save$info.robust.vec, ncol=n.gamma)
  save$info <- matrix(save$info.vec, ncol=n.gamma)

  deriv.vec <- numeric(n.utype)
  for(i in 1:n.utype){
    deriv.vec[i] <- derivC2lambda(int.type[i], c=c.coef[i])
  }

  nparm <- n.utype + 1

  hmat <- h1 <- h2 <- matrix(numeric(nparm*(nparm-2)), ncol=nparm)
  h1[,rep(2,(nparm-2))] <- deriv.vec[1]
  h2[cbind( (1:(nparm-2)), (3:nparm))] <- deriv.vec[-1]
  hmat <-  h1 - h2
 
  u <- save$u.scores
  info.w <- save$info
  info.r <- save$info.robust

  t1 <- hmat%*%solve(info.w)

  x <- t1 %*% u

  v <- t1 %*% info.r %*% t(t1)

  tmp <- Ginv(v)
  vinv <- tmp$Ginv

  df <- tmp$rank
  stat <- t(x) %*% vinv %*% x
  pval <- 1-pchisq(stat,df)

  return(list(stat=stat, df=df, pval=pval))

}

 
