#$Author: sinnwell $
#$Date: 2005/02/08 23:07:05 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/print.arp.ibd.q,v 1.5 2005/02/08 23:07:05 sinnwell Exp $
#$Locker:  $
#$Log: print.arp.ibd.q,v $
#Revision 1.5  2005/02/08 23:07:05  sinnwell
#use printBanner in place of two cat() calls
#
#Revision 1.4  2005/02/08 17:28:21  sinnwell
#change width on line for parameter table
#
#Revision 1.3  2004/10/08 18:28:08  sinnwell
#add digits parameter
#
#Revision 1.2  2004/10/08 17:34:51  schaid
#add print if failed to converge
#
#Revision 1.1  2004/10/07 21:54:01  sinnwell
#Initial revision
#
print.arp.ibd <- function(x, digits=max(options()$digits - 4, 5), ...)
# Sinnwell, JP  6/2004
{
  
# print the table of parameter estimates

  if(x$converge == 1){
    tmp <- paste("Parameter estimates and", as.character(100 * 
        x$ci.prob), "% confidence intervals")
    printBanner(tmp)
    print(x$tbl, digits=digits)
 
    cat("\n")
  
    if(x$model=="C") {
      printBanner("Lambdas transformed from estimated Cs")
      print(x$lambda, digits=digits)
    }
     
    cat("\n \n")
  }

 if(x$converge != 1){
   cat("Convergence not met\n\n")

    tbl <- data.frame(param = x$gamma, u.scores = x$u.scores)
    printBanner("Parameter estimates and scores")
    print(tbl, digits=digits)
    cat("\n\nNo. iterations = ",x$iter)
    cat("\n \n")
  }
     
  invisible(x)
}
