#$Author: sinnwell $
#$Date: 2004/10/07 21:51:07 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/c2lambda.q,v 1.1 2004/10/07 21:51:07 sinnwell Exp $
#$Locker:  $
#$Log: c2lambda.q,v $
#Revision 1.1  2004/10/07 21:51:07  sinnwell
#Initial revision
#
c2lambda <- function(type, c){
 switch(type,
  { # full sibs 
      lambda <-  1/(1-2*c)
  },

  {  #half-sibs
      lambda <- (1+2*c)/(1-2*c)
  },

  { # first cousins
      lambda <- (12*c + 3)/(3- 4*c)
  },

  { # grandparent - grandchild
     lambda <- (1+2*c)/(1-2*c)
   },

  { #uncle-nephew
     lambda <- (1+2*c)/(1-2*c)
   }
 )

  return(lambda)
}
