#$Date: 2004/12/30 22:22:43 $
#$Header: /people/biostat3/sinnwell/Projects/arp.gee/Make/RCS/arp.ibd.q,v 1.7 2004/12/30 22:22:43 sinnwell Exp $
#$Locker:  $
#$Log: arp.ibd.q,v $
#Revision 1.7  2004/12/30 22:22:43  sinnwell
#track which tau.init values converge, use those in summary.df
#the multiple starting values make non-convergence tracking less an issue
#
#Revision 1.6  2004/11/23 20:20:10  sinnwell
#check limits on top.pct
#
#Revision 1.5  2004/11/22 23:00:34  sinnwell
#move assignments in case of non-converge
#
#Revision 1.4  2004/11/19 23:01:40  sinnwell
#newer version of arp.ibd, fitter
#
#Revision 1.3  2004/10/10 21:16:29  schaid
#moved class definition to immediately after creation of 'save' objects, so that
# the object is created even if the function quits early due to non-convergence.
#
#Revision 1.2  2004/10/08 17:34:18  schaid
#added measure of goodness of fit to returned object
#
#Revision 1.1  2004/10/07 21:50:45  sinnwell
#Initial revision
#

arp.ibd <- function(ibd.obj, model='C', top.pct=.4, end.cut=10, near.rng=10,
                    tau.init=NA, c.init=NA, lambda.init=NA,
                    ci.prob=.95, max.iter=50,tol=1e-4,eps=1,print.iter=FALSE)
{

# select the best arp.ibd fit based on gof measure.

 if(class(ibd.obj)!="ibd.share"){
    stop("Object not of class ibd.share")
  }

  # check model: either C or lambda
  model <- casefold(model,upper=TRUE)
  model.indx <- pmatch(model,c("C","LAMBDA"))
  if(is.na(model.indx)){
    stop("Model not defined: use either C or LAMBDA")
  }
  model <- c("C","LAMBDA")[model.indx]

  
# if no tau.init given, 
# choose from select starting values given from ibd.peaks()

  pos <- ibd.obj$pos
  y.mean <- apply(ibd.obj$smat, 2, mean)
  
  if(length(tau.init)==1 && is.na(tau.init)){
    if(top.pct<=0 | top.pct > 1) {
      warning("top.pct out of range (0,1], default value used")
      top.pct <- .4
    }
    tau.init <- ibd.peaks(pos, y.mean, top.pct=top.pct, end.cut=end.cut, near.rng=near.rng)
  }

  # store results from each run of arp.ibd.fitter
  tau.init.keep <- gof.model <- tau.est <- lambda <- numeric(0)
 
  # save the gof and tau from the best arp.ibd model
  gof.save <- tau.save <- NULL

  arp.ibd.save <- arp.ibd.fitter(ibd.obj, model=model, tau.init=tau.init[1],
                    ci.prob=ci.prob, max.iter=max.iter,tol=tol,eps=eps,
                    print.iter=print.iter, c.init=c.init,lambda.init=lambda.init)

  if(arp.ibd.save$converge==1) {
    gof.save <- gof.model <- arp.ibd.save$gof
    lambda <- arp.ibd.save$gamma[-1]
    tau.save <- tau.est <- arp.ibd.save$gamma[1]
    tau.init.keep <- tau.init[1]
  }

  if(length(tau.init)>1) {
    for (i in 2:length(tau.init)) {

      tmp <- arp.ibd.fitter(ibd.obj, model=model, tau.init=tau.init[i],
                 ci.prob=ci.prob, max.iter=max.iter,tol=tol,eps=eps,
                 print.iter=print.iter, c.init=c.init,lambda.init=lambda.init)
      
    # check convergence of tmp
      if(tmp$converge==1) {
        # save results from each tau.init
        # save better model between tmp and arp.ibd.save
        gof.model <- c(gof.model,tmp$gof)
        lambda <- rbind(lambda, tmp$gamma[-1])
        tau.est <- c(tau.est,tmp$gamma[1])
        tau.init.keep <- c(tau.init.keep, tau.init[i])

        if(tmp$gof>gof.save) {
          tau.save <- tmp$gamma[1]
          arp.ibd.save <- tmp
          gof.save <- tmp$gof
        } else if((tmp$gof==gof.save) & (tau.save != tmp$gamma[1])) {
          warning("Estimated two distinct trait positions that are equivalent")
        }
      }
    }
  }

  if(length(tau.est)) {
    # arrange summary.df with results for each tau.init
    if(model=="C") {
      if(length(tau.est)==1) lambda <- as.data.frame(matrix(lambda,ncol=length(lambda)))
      dimnames(lambda)[[2]] <- paste("C=", as.character(unique(ibd.obj$type)), sep="")
    }
    arp.ibd.save$summary.df <- data.frame(tau.init=tau.init.keep,tau.est,lambda,gof.model,row.names=1:length(tau.est))
  } else arp.ibd.save$summary.df <- list(tau.init=tau.init, tau.est=arp.ibd.save$gamma[1])
 
  return(arp.ibd.save)
}
