arp.gof <- function(ibd.obj, model.fit){

# measure goodness of fit of a model, relative to a null model with
# only intercepts (random sharing for type of ARP), with an r^2 measure,
# calculated as s simple residual sums of squares (not weighted by
# inverse of covariance matrix, since this requires more work to
# figure out if it will give sensible results).



  resid.model.c <- function(smat,type.cat,pos,tau,c.coef,eps){
    fit <- arp.fit(type=type.cat, pos=pos, tau=tau, c.coef=c.coef, eps=eps)$s.fit
    resid <- smat - matrix(rep(fit,nrow(smat)),nrow=nrow(smat),byrow=TRUE)
    return(resid)
  }

  resid.null <- function(smat,type.cat){
    resid <- smat -  switch(type.cat, 1, 0.5, 0.25, 0.5, 0.5)
    return(resid)
  }

  smat <- ibd.obj$smat
  type <- as.numeric(ibd.obj$type)
  ord <- order(type)
  smat <- smat[ord,]
  type <- type[ord]

  pos <- model.fit$pos
  utype <- sort(unique(type))
  tau <- model.fit$gamma[1]
  eps <- model.fit$eps

  rss.model.type <- rss.null.type <- numeric(length(utype))

  for(i in 1:length(utype)){

    switch(model.fit$model,
       C      = {  c.coef <- model.fit$gamma[i+1] },
       LAMBDA = {  c.coef <- lambda2c(type=utype[i], model.fit$gamma[2]) },
      {stop("Wrong model for calculating residuals")}
    )

    zed <- type==utype[i]

    res.null <- resid.null(smat=smat[zed,],type.cat=utype[i])
    rss.null.type[i] <- sum(diag(res.null %*% t(res.null)))

    res.m <- resid.model.c(smat=smat[zed,],type.cat=utype[i],pos=pos,tau=tau,c.coef=c.coef,eps=eps)  
    rss.model.type[i] <- sum(diag(res.m %*% t(res.m)))

  }

  r2 <- 1 - sum(rss.model.type)/sum(rss.null.type)

  return(r2)
}
