% $Author: sinnwell $
% $Date: 2009/06/04 21:16:15 $
% $Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/geno2to1.Rd,v 1.2 2009/06/04 21:16:15 sinnwell Exp $
% $Locker:  $ 
% $Log:

\name{geno2to1}
\alias{geno2to1}
\title{
  convert genotype matrix from 2-column to 1-column
}
\description{
convert a 2-column genotype matrix to 1-column genotype matrix:
a 2-column representation of the allele pair for each subject
to a1-column representation with minor allele count, 
i.e. genotypes [1/1, 1/2, 2/2] convert to [0,1,2] where 2 was the minor allele. 
(not applicable for x-linked markers)
}
\usage{
geno2to1(geno, miss.val=c(0,NA))
}
\arguments{

\item{geno}{
Matrix of alleles, such that each locus has a pair of
adjacent columns of alleles, and the order of columns
corresponds to the order of loci on a chromosome.  If
there are K loci, then ncol(geno) = 2*K. Rows represent
alleles for each subject.
}
\item{miss.val}{
  Codes for missing alleles. If either of the two alleles code to
  missing, the 1-column count is NA.
}
}
\value{
The 1-column representation of the genotypes with count of minor alleles
}
\section{Side Effects}{

}
\details{

}
\section{References}{

}
\seealso{
\code{\link{geno1to2}},
\code{\link{setupGeno}}
}
\examples{
geno2 <- matrix(c(1,1,1,2,
                  1,2,1,2,
                  2,2,1,1), ncol=4, byrow=TRUE)

geno1 <- geno2to1(geno2)

geno1
#     SNP1 SNP2 
#[1,]    2    1
#[2,]    1    1
#[3,]    0    0
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 37351.
