#$Author: sinnwell $
#$Date: 2009/06/16 18:31:51 $
#$Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/geno2to1.q,v 1.4 2009/06/16 18:31:51 sinnwell Exp $
#$Locker:  $
#$Log: geno2to1.q,v $
#Revision 1.4  2009/06/16 18:31:51  sinnwell
#change which.mina again
#
#Revision 1.3  2009/06/08 16:48:10  sinnwell
#fix bug for all NA or monomorphic
#
#Revision 1.2  2009/06/04 21:12:28  sinnwell
#add miss.val option
#
#Revision 1.1  2007/10/15 19:33:18  sinnwell
#Initial revision
#

geno2to1 <- function(geno, miss.val=c(0,NA)) {
  ## Convert 2-column allele format matrix to
  ## single column allele-count columns
  nmark <- ncol(geno)/2
  onemat <- matrix(NA, ncol=nmark, nrow=nrow(geno),
                   dimnames=list(dimnames(geno)[[1]],
                     paste('SNP',1:nmark,sep='')))
  n <- nrow(geno)
  for(i in 1:nmark) {
    a1 <- geno[,(i*2 - 1)]
    a2 <- geno[,(i*2)]
    fact <- factor(c(a1, a2), exclude = miss.val)
    
    a1 <- levels(fact)[fact[1:n]]
    a2 <- levels(fact)[fact[(n + 1):(2 * n)]]
    atbl <- table(c(a1,a2), exclude=NA)

    if(length(atbl) < 2)  atbl <- c(atbl, dummy=0)
    
    which.mina <- which(atbl == min(atbl))[1]
  
    cnt <- (a1 == names(atbl)[which.mina]) + (a2==names(atbl)[which.mina])    
    onemat[,i] <- cnt

  }
  return(onemat)
}
