% $Author: sinnwell $
% $Date: 2008/01/04 22:18:29 $
% $Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/armitage.concat.Rd,v 1.1 2008/01/04 22:18:29 sinnwell Exp $
% $Locker:  $ 
% $Log:


\name{armitage.concat}
\alias{armitage.concat}
\title{
  Concatenates together objects of class armitage.
}
\description{
Combines armitage objects together into a single armitage object.
Allows correction for multiple comparisons over multiple strata
}
\usage{
armitage.concat(x)
}
\arguments{
\item{x}{
A list of objects returned from armitage.  Each element of x must be
class armitage.  Note that each element of x must have been generated
using the same number of simulations (nsim).
}
}
\value{
The returned object is an object of class armitage which is a list
with the following components:

\item{nsubj}{
Matrix containing one row with the number of cases and controls for
each element of x.
}
\item{ngeno}{
Vector of number of markers analyzed for each element of x.
}
\item{nsim}{
The number of simulations performed
}
\item{statObs}{
A vector of observed chi square statistics.  Length is equal to ngeno.
}
\item{statSim}{
Matrix of simulated statistics. Each row of statSim contains
statistics for all markers for a single simulation.  Dimensions are
nsim*ngeno.
}
\item{snpLabels}{
Vector of labels.  Labels consist of individual snpLabels from each
element in x along with the names of elements of x.
}
}
\details{

}
\seealso{
\code{\link{armitage}},
\code{\link{print.armitage}},
\code{\link{summary.armitage}}
}
\examples{
setupData(seqhap.dat)
y <- seqhap.dat[,1]
geno <- seqhap.dat[,-1]
##  Convert to single allele count var for each marker
gmat <- geno2to1(geno)

arm.fit.add <- armitage(y, gmat, snpLabels=dimnames(gmat)[[2]], dose=0:2, nsim=100)
arm.fit.dom <- armitage(y, gmat, snpLabels=dimnames(gmat)[[2]], dose=c(0,1,1), nsim=100)
arm.fit.rec <- armitage(y, gmat, snpLabels=dimnames(gmat)[[2]], dose=c(0,0,1), nsim=100)

## NOTE:  Must Name elements of armitage.concat input list in order to have
##        nice names in result
arm.fits <- armitage.concat(list(Add=arm.fit.add, Dom=arm.fit.dom, Rec=arm.fit.rec))
arm.fits
summary(arm.fits)
}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 37351.
