/* $Author: sinnwell $ */
/* $Date: 2007/10/16 14:58:11 $ */
/* $Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/quicksortFolie.c,v 1.2 2007/10/16 14:58:11 sinnwell Exp $ */
/* $Locker:  $ */
/*
 * $Log: quicksortFolie.c,v $
 * Revision 1.2  2007/10/16 14:58:11  sinnwell
 * removed template for qs, which is in .h file
 *
 * Revision 1.1  2007/10/15 19:34:25  sinnwell
 * Initial revision
 * * 
 */
#include "quicksortFolie.h"


/* Changes by Dan Schaid: 
   changed long to int, to be used in R
   changed array_permute to range from 0 ... n-1, instead of 1 ... n 
   changed to not initialize array_permute for quicksort_permute,  just let the user input an array
*/

/* QUICKSORT_PERMUTE and QUICKSORT_ORDINAL 
  
				   FUNCTION ARGUMENTS 
These functions, quicksort_permute and quicksort_ordinal, take the following 
arguments:

n: 	       A int integer giving the length of the array to be sorted
array_sort:    A double array of length n to be sorted
array_permute: A int array of length n that will contain the 
	       sequence 1,2,...n permuted to the order corresponding
	       to the sorting of array_sort (see user's manual below).
	       This order will vary slightly depending on whether 
	       quicksort_permute or quicksort_ordinal is used.
temp           A int array of length *n that is used for scratch space (used in
               quicksort_ordinal() only).

				   SIDE EFFECTS
The array array_sort will be returned in sorted order from lowest to highest. 
And array_permute will be returned containg a permutation of 1,2,...,n.  The 
particular permutation varies depending upon which method is called (see user's
manual).

				   RETURN CODES
The following return codes may be returned:
	0:     Successful completion
       -1:     Array length degenerate (lesss than or equal to zero)

				   USER MANUAL
These functions, quicksort_permute and quicksort_ordinal, both use
the main qs(...) engine to perform a quicksort on the elements of 
array_sort (shorthand for "array to be sorted") and return a permutation
of the elements of array_permute ("array to be permuted").  The primary 
difference should be made apparent by the following:

let a[] = {0.8, 0.4, 0.5, 0.2, 0.7, 0.1, 0.6, 0.3}
    b[] = {1,   2,   3,   4,   5,   6,   7,   8  }  

then 

quicksort_permute(8, a, b,) returns

   a[] = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8}
   b[] = {6,   4,   8,   2,   3,   7,   5,   1  }

and quicksort_ordinal(8, a, b) returns 

   a[] = {0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8}
   b[] = {8,   4,   5,   2,   7,   1,   6,   3  }

It should be noted that the array of 1,2,...,n - in this case b[] - does 
not need to contain the integers at the time of the call to either 
of the above functions.  It must simply be a int array of length n.  


To demo how to use this within a simulation loop:

 indexVec is a vector of vector indices, with values  0 ... (n-1)

 set random seed

 ranAS183_seed(*iseed1, *iseed2, *iseed3);


 for(j = 0; j < n; j++)
  {
  randomVec[j] = ranAS183();
  }


  quicksort_permute(n, randomVec, indexVec);


*/


int quicksort_ordinal(int n, double array_sort[], int array_permute[],
		             int temp[])
{
  int i; 
  
  if(n <= 0)
    return -1;			      /* non-sensical array length	       */
  
  for(i = 0; i < n; i++)	      /* Initialize array_permute to 0,1,...,n-1 */
    array_permute[i] = i;

  qs(0, n - 1, array_sort, array_permute);
	
  for(i = 0; i < n; i++)
	temp[array_permute[i]] = i;
  for(i = 0; i < n; i++)
    	array_permute[i] = temp[i];

  return 0;
}

int quicksort_permute(int n, double array_sort[], int array_permute[])
{
  int i; 
  
  if(n <= 0)
    return -1;			      /* non-sensical array length	       */

  qs(0, n - 1, array_sort, array_permute);
  return 0;
}


static void qs(int left, int right, double array_sort[], int array_permute[])
{
  int i,j, temp_permute;
  double mid, temp_sort;

  i = left; j = right;
  mid = array_sort[(left + right) / 2];

  do {
    while(array_sort[i] < mid && i < right) i++;
    while(mid < array_sort[j] && left < j) j--;
    
    if(i<=j) {
      temp_sort = array_sort[i];		/* swap elements	       */
      array_sort[i] = array_sort[j];
      array_sort[j] = temp_sort;
					     
      temp_permute = array_permute[i];		/* comes along for the ride... */
      array_permute[i] = array_permute[j];
      array_permute[j] = temp_permute;
      
      i++; j--;
    }
  } while(i <= j);

  if(left < j) 
    qs(left, j, array_sort, array_permute);
  if(i < right) 
    qs(i, right, array_sort, array_permute);

  return; 
}
