% $Author: sinnwell $ -->
% $Date: 2008/01/08 16:10:12 $ -->
% $Header: /people/biostat3/sinnwell/genet/rpack/Armitage/RCS/summary.armitage.Rd,v 1.2 2008/01/08 16:10:12 sinnwell Exp $ -->
% $Locker:  $ -->
% $Log: summary.armitage.Rd,v $
% Revision 1.2  2008/01/08 16:10:12  sinnwell
% minor change
%
% Revision 1.1  2008/01/04 22:12:33  sinnwell
% Initial revision
% Revision 1.1  2007/10/15 19:32:39 sinnwell 

\name{summary.armitage}
\alias{summary.armitage}
\title{
  Summarize an object of class armitage
}
\description{
Calculate asymptotic, simulated, and multiple comparison corrected
p-values for Armitage trend statistics.  
}
\usage{
\method{summary}{armitage}(object)
}
\arguments{
\item{object}{
The object returned from armitage (which has class armitage).
}
}
\value{
A dataframe containing the following columns:  snp (x\$snpLabels),
chistat (x\$statObs), pval.asymp (asymptotic p-value), pval.perm
(simulated p-value), and pval.corrected (multiple comparison
corrected p-value).
}
\details{
The multiple comparison corrected p-values are calculated using the
method described on page 75 of Westfall et al., "Multiple comparisons
and multiple tests using SAS."  Corrected p-values are: 
Pr(max sim stat >= obs stat) for each observed statistic.
}
\section{References}{
Westfall P, Tobias R, Rom D, Wolfinger R, Hochberg Y. Multiple
comparisons and multiple tests using SAS. Cary (NC): SAS
Institute; 2004.
}
\seealso{
\code{\link{armitage}},
\code{\link{print.armitage}},
\code{\link{armitage.concat}}
}
\examples{

}
\keyword{}
% docclass is function
% Converted by Sd2Rd version 37351.
